package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev181109;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHopsKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Destination;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Source;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Class that builds {@link PcepCreateP2pTunnelInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     PcepCreateP2pTunnelInput createPcepCreateP2pTunnelInput(int fooXyzzy, int barBaz) {
 *         return new PcepCreateP2pTunnelInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of PcepCreateP2pTunnelInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see PcepCreateP2pTunnelInput
 *
 */
@Generated("mdsal-binding-generator")
public class PcepCreateP2pTunnelInputBuilder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Nanotime _deadline;
    private Destination _destination;
    private AttributeFilter _excludeAny;
    private Map<ExplicitHopsKey, ExplicitHops> _explicitHops;
    private Uint8 _holdPriority;
    private InstructionId _id;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private NetworkTopologyRef _networkTopologyRef;
    private Set<InstructionId> _preconditions;
    private Boolean _seStyleDesired;
    private String _sessionName;
    private Uint8 _setupPriority;
    private Source _source;
    private String _symbolicPathName;


    Map<Class<? extends Augmentation<PcepCreateP2pTunnelInput>>, Augmentation<PcepCreateP2pTunnelInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public PcepCreateP2pTunnelInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link CreateP2pTunnelInput}.
     *
     * @param arg CreateP2pTunnelInput from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(CreateP2pTunnelInput arg) {
        this._destination = arg.getDestination();
        this._source = arg.getSource();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    /**
     * Construct a new builder initialized from specified {@link SubmitInstructionInput}.
     *
     * @param arg SubmitInstructionInput from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    
    /**
     * Construct a new builder initialized from specified {@link NetworkTopologyReference}.
     *
     * @param arg NetworkTopologyReference from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link TunnelP2pPathCfgAttributes}.
     *
     * @param arg TunnelP2pPathCfgAttributes from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(TunnelP2pPathCfgAttributes arg) {
        this._explicitHops = arg.getExplicitHops();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link TunnelPcepLinkCfgAttributes}.
     *
     * @param arg TunnelPcepLinkCfgAttributes from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link TunnelAttributes}.
     *
     * @param arg TunnelAttributes from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.getLocalProtectionDesired();
        this._labelRecordingDesired = arg.getLabelRecordingDesired();
        this._seStyleDesired = arg.getSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    
    /**
     * Construct a new builder initialized from specified {@link Priority}.
     *
     * @param arg Priority from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    
    /**
     * Construct a new builder initialized from specified {@link AttributeFilters}.
     *
     * @param arg AttributeFilters from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link PcepCreateP2pTunnelInput}.
     *
     * @param base PcepCreateP2pTunnelInput from which the builder should be initialized
     */
    public PcepCreateP2pTunnelInputBuilder(final PcepCreateP2pTunnelInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._deadline = base.getDeadline();
        this._destination = base.getDestination();
        this._excludeAny = base.getExcludeAny();
        this._explicitHops = base.getExplicitHops();
        this._holdPriority = base.getHoldPriority();
        this._id = base.getId();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._labelRecordingDesired = base.getLabelRecordingDesired();
        this._localProtectionDesired = base.getLocalProtectionDesired();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        this._seStyleDesired = base.getSeStyleDesired();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._source = base.getSource();
        this._symbolicPathName = base.getSymbolicPathName();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SubmitInstructionInput}</li>
     *   <li>{@link TunnelP2pPathCfgAttributes}</li>
     *   <li>{@link Priority}</li>
     *   <li>{@link AttributeFilters}</li>
     *   <li>{@link NetworkTopologyReference}</li>
     *   <li>{@link TunnelPcepLinkCfgAttributes}</li>
     *   <li>{@link TunnelAttributes}</li>
     *   <li>{@link CreateP2pTunnelInput}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(final Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof SubmitInstructionInput castArg) {
            this._id = castArg.getId();
            this._deadline = castArg.getDeadline();
            this._preconditions = castArg.getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof TunnelP2pPathCfgAttributes castArg) {
            this._explicitHops = castArg.getExplicitHops();
            isValidArg = true;
        }
        if (arg instanceof Priority castArg) {
            this._holdPriority = castArg.getHoldPriority();
            this._setupPriority = castArg.getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters castArg) {
            this._includeAny = castArg.getIncludeAny();
            this._excludeAny = castArg.getExcludeAny();
            this._includeAll = castArg.getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof NetworkTopologyReference castArg) {
            this._networkTopologyRef = castArg.getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof TunnelPcepLinkCfgAttributes castArg) {
            this._symbolicPathName = castArg.getSymbolicPathName();
            this._classType = castArg.getClassType();
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes castArg) {
            this._localProtectionDesired = castArg.getLocalProtectionDesired();
            this._labelRecordingDesired = castArg.getLabelRecordingDesired();
            this._seStyleDesired = castArg.getSeStyleDesired();
            this._sessionName = castArg.getSessionName();
            isValidArg = true;
        }
        if (arg instanceof CreateP2pTunnelInput castArg) {
            this._destination = castArg.getDestination();
            this._source = castArg.getSource();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SubmitInstructionInput, TunnelP2pPathCfgAttributes, Priority, AttributeFilters, NetworkTopologyReference, TunnelPcepLinkCfgAttributes, TunnelAttributes, CreateP2pTunnelInput]");
    }


    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getClassType()}.
     *
     * @return current value
     */
    public ClassType getClassType() {
        return _classType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getDeadline()}.
     *
     * @return current value
     */
    public Nanotime getDeadline() {
        return _deadline;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getDestination()}.
     *
     * @return current value
     */
    public Destination getDestination() {
        return _destination;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getExcludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getExplicitHops()}.
     *
     * @return current value
     */
    public Map<ExplicitHopsKey, ExplicitHops> getExplicitHops() {
        return _explicitHops;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getHoldPriority()}.
     *
     * @return current value
     */
    public Uint8 getHoldPriority() {
        return _holdPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getId()}.
     *
     * @return current value
     */
    public InstructionId getId() {
        return _id;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getIncludeAll()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getIncludeAny()}.
     *
     * @return current value
     */
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getLabelRecordingDesired()}.
     *
     * @return current value
     */
    public Boolean getLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getLocalProtectionDesired()}.
     *
     * @return current value
     */
    public Boolean getLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getNetworkTopologyRef()}.
     *
     * @return current value
     */
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getPreconditions()}.
     *
     * @return current value
     */
    public Set<InstructionId> getPreconditions() {
        return _preconditions;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getSeStyleDesired()}.
     *
     * @return current value
     */
    public Boolean getSeStyleDesired() {
        return _seStyleDesired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getSessionName()}.
     *
     * @return current value
     */
    public String getSessionName() {
        return _sessionName;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getSetupPriority()}.
     *
     * @return current value
     */
    public Uint8 getSetupPriority() {
        return _setupPriority;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getSource()}.
     *
     * @return current value
     */
    public Source getSource() {
        return _source;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link PcepCreateP2pTunnelInput#getSymbolicPathName()}.
     *
     * @return current value
     */
    public String getSymbolicPathName() {
        return _symbolicPathName;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<PcepCreateP2pTunnelInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getDeadline()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setDeadline(final Nanotime value) {
        this._deadline = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getDestination()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setDestination(final Destination value) {
        this._destination = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getExcludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getExplicitHops()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setExplicitHops(final Map<ExplicitHopsKey, ExplicitHops> values) {
        this._explicitHops = values;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getHoldPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setHoldPriority(final Uint8 value) {
        this._holdPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setId(final InstructionId value) {
        this._id = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getIncludeAll()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getIncludeAny()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getLabelRecordingDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setLabelRecordingDesired(final Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getLocalProtectionDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setLocalProtectionDesired(final Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getNetworkTopologyRef()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getPreconditions()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setPreconditions(final Set<InstructionId> values) {
        this._preconditions = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getSeStyleDesired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setSeStyleDesired(final Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getSessionName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setSessionName(final String value) {
        this._sessionName = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getSetupPriority()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setSetupPriority(final Uint8 value) {
        this._setupPriority = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getSource()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setSource(final Source value) {
        this._source = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link PcepCreateP2pTunnelInput#getSymbolicPathName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PcepCreateP2pTunnelInputBuilder setSymbolicPathName(final String value) {
        this._symbolicPathName = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PcepCreateP2pTunnelInputBuilder addAugmentation(Augmentation<PcepCreateP2pTunnelInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PcepCreateP2pTunnelInputBuilder removeAugmentation(Class<? extends Augmentation<PcepCreateP2pTunnelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link PcepCreateP2pTunnelInput} instance.
     *
     * @return A new {@link PcepCreateP2pTunnelInput} instance.
     */
    public @NonNull PcepCreateP2pTunnelInput build() {
        return new PcepCreateP2pTunnelInputImpl(this);
    }

    private static final class PcepCreateP2pTunnelInputImpl
        extends AbstractAugmentable<PcepCreateP2pTunnelInput>
        implements PcepCreateP2pTunnelInput {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Nanotime _deadline;
        private final Destination _destination;
        private final AttributeFilter _excludeAny;
        private final Map<ExplicitHopsKey, ExplicitHops> _explicitHops;
        private final Uint8 _holdPriority;
        private final InstructionId _id;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final NetworkTopologyRef _networkTopologyRef;
        private final Set<InstructionId> _preconditions;
        private final Boolean _seStyleDesired;
        private final String _sessionName;
        private final Uint8 _setupPriority;
        private final Source _source;
        private final String _symbolicPathName;
    
        PcepCreateP2pTunnelInputImpl(final PcepCreateP2pTunnelInputBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._deadline = base.getDeadline();
            this._destination = base.getDestination();
            this._excludeAny = base.getExcludeAny();
            this._explicitHops = CodeHelpers.emptyToNull(base.getExplicitHops());
            this._holdPriority = base.getHoldPriority();
            this._id = base.getId();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._labelRecordingDesired = base.getLabelRecordingDesired();
            this._localProtectionDesired = base.getLocalProtectionDesired();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            this._seStyleDesired = base.getSeStyleDesired();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._source = base.getSource();
            this._symbolicPathName = base.getSymbolicPathName();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Nanotime getDeadline() {
            return _deadline;
        }
        
        @Override
        public Destination getDestination() {
            return _destination;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public Map<ExplicitHopsKey, ExplicitHops> getExplicitHops() {
            return _explicitHops;
        }
        
        @Override
        public Uint8 getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public InstructionId getId() {
            return _id;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public Boolean getLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public Boolean getLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public Set<InstructionId> getPreconditions() {
            return _preconditions;
        }
        
        @Override
        public Boolean getSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @Override
        public String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public Uint8 getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public Source getSource() {
            return _source;
        }
        
        @Override
        public String getSymbolicPathName() {
            return _symbolicPathName;
        }
    
        
        
        
        @Override
        public Destination nonnullDestination() {
            return Objects.requireNonNullElse(getDestination(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.DestinationBuilder.empty());
        }
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        @Override
        public Source nonnullSource() {
            return Objects.requireNonNullElse(getSource(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.SourceBuilder.empty());
        }
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = PcepCreateP2pTunnelInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return PcepCreateP2pTunnelInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return PcepCreateP2pTunnelInput.bindingToString(this);
        }
    }
}
