package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev181109;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;

/**
 * Class that builds {@link Paths1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Paths1 createPaths1(int fooXyzzy, int barBaz) {
 *         return new Paths1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Paths1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Paths1
 *
 */
@Generated("mdsal-binding-generator")
public class Paths1Builder {




    /**
     * Construct an empty builder.
     */
    public Paths1Builder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Paths1}.
     *
     * @param base Paths1 from which the builder should be initialized
     */
    public Paths1Builder(final Paths1 base) {
    }




    

    /**
     * A new {@link Paths1} instance.
     *
     * @return A new {@link Paths1} instance.
     */
    public @NonNull Paths1 build() {
        return new Paths1Impl(this);
    }

    private static final class Paths1Impl
        implements Paths1 {
    
    
        Paths1Impl(final Paths1Builder base) {
        }
    
    
    
    
    
        @Override
        public String toString() {
            return Paths1.bindingToString(this);
        }
    }
}
