/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepDestroyTunnelInputBuilder {
    private Nanotime _deadline;
    private static List<Range<BigInteger>> _deadline_range;
    private InstructionId _id;
    private LinkId _linkId;
    private NetworkTopologyRef _networkTopologyRef;
    private List<InstructionId> _preconditions;
    Map<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>> augmentation = new HashMap<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>>();

    public PcepDestroyTunnelInputBuilder() {
    }

    public PcepDestroyTunnelInputBuilder(BaseTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public PcepDestroyTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }

    public PcepDestroyTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public PcepDestroyTunnelInputBuilder(PcepDestroyTunnelInput base) {
        this._deadline = base.getDeadline();
        this._id = base.getId();
        this._linkId = base.getLinkId();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        if (base instanceof PcepDestroyTunnelInputImpl) {
            PcepDestroyTunnelInputImpl _impl = (PcepDestroyTunnelInputImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NetworkTopologyReference) {
            this._networkTopologyRef = ((NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof BaseTunnelInput) {
            this._linkId = ((BaseTunnelInput)arg).getLinkId();
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput) {
            this._id = ((SubmitInstructionInput)arg).getId();
            this._deadline = ((SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput] \nbut was: " + arg);
        }
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public InstructionId getId() {
        return this._id;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public NetworkTopologyRef getNetworkTopologyRef() {
        return this._networkTopologyRef;
    }

    public List<InstructionId> getPreconditions() {
        return this._preconditions;
    }

    public <E extends Augmentation<PcepDestroyTunnelInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcepDestroyTunnelInputBuilder setDeadline(Nanotime value) {
        if (value != null) {
            BigInteger _constraint = value.getValue();
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepDestroyTunnelInputBuilder._deadline_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _deadline_range));
            }
        }
        this._deadline = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _deadline_range() {
        if (_deadline_range != null) return _deadline_range;
        Class<PcepDestroyTunnelInputBuilder> clazz = PcepDestroyTunnelInputBuilder.class;
        synchronized (PcepDestroyTunnelInputBuilder.class) {
            if (_deadline_range != null) return _deadline_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
            _deadline_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _deadline_range;
        }
    }

    public PcepDestroyTunnelInputBuilder setId(InstructionId value) {
        this._id = value;
        return this;
    }

    public PcepDestroyTunnelInputBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public PcepDestroyTunnelInputBuilder setNetworkTopologyRef(NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }

    public PcepDestroyTunnelInputBuilder setPreconditions(List<InstructionId> value) {
        this._preconditions = value;
        return this;
    }

    public PcepDestroyTunnelInputBuilder addAugmentation(Class<? extends Augmentation<PcepDestroyTunnelInput>> augmentationType, Augmentation<PcepDestroyTunnelInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcepDestroyTunnelInput build() {
        return new PcepDestroyTunnelInputImpl(this);
    }

    private static final class PcepDestroyTunnelInputImpl
    implements PcepDestroyTunnelInput {
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final LinkId _linkId;
        private final NetworkTopologyRef _networkTopologyRef;
        private final List<InstructionId> _preconditions;
        private Map<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>> augmentation = new HashMap<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>>();

        public Class<PcepDestroyTunnelInput> getImplementedInterface() {
            return PcepDestroyTunnelInput.class;
        }

        private PcepDestroyTunnelInputImpl(PcepDestroyTunnelInputBuilder base) {
            this._deadline = base.getDeadline();
            this._id = base.getId();
            this._linkId = base.getLinkId();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>>(base.augmentation);
                }
            }
        }

        public Nanotime getDeadline() {
            return this._deadline;
        }

        public InstructionId getId() {
            return this._id;
        }

        public LinkId getLinkId() {
            return this._linkId;
        }

        public NetworkTopologyRef getNetworkTopologyRef() {
            return this._networkTopologyRef;
        }

        public List<InstructionId> getPreconditions() {
            return this._preconditions;
        }

        public <E extends Augmentation<PcepDestroyTunnelInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._deadline == null ? 0 : this._deadline.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._linkId == null ? 0 : this._linkId.hashCode());
            result = 31 * result + (this._networkTopologyRef == null ? 0 : this._networkTopologyRef.hashCode());
            result = 31 * result + (this._preconditions == null ? 0 : this._preconditions.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepDestroyTunnelInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepDestroyTunnelInput other = (PcepDestroyTunnelInput)obj;
            if (this._deadline == null ? other.getDeadline() != null : !this._deadline.equals((Object)other.getDeadline())) {
                return false;
            }
            if (this._id == null ? other.getId() != null : !this._id.equals((Object)other.getId())) {
                return false;
            }
            if (this._linkId == null ? other.getLinkId() != null : !this._linkId.equals((Object)other.getLinkId())) {
                return false;
            }
            if (this._networkTopologyRef == null ? other.getNetworkTopologyRef() != null : !this._networkTopologyRef.equals((Object)other.getNetworkTopologyRef())) {
                return false;
            }
            if (this._preconditions == null ? other.getPreconditions() != null : !this._preconditions.equals(other.getPreconditions())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepDestroyTunnelInputImpl otherImpl = (PcepDestroyTunnelInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepDestroyTunnelInput>>, Augmentation<PcepDestroyTunnelInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcepDestroyTunnelInput [");
            boolean first = true;
            if (this._deadline != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadline=");
                builder.append(this._deadline);
            }
            if (this._id != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_id=");
                builder.append(this._id);
            }
            if (this._linkId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_linkId=");
                builder.append(this._linkId);
            }
            if (this._networkTopologyRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_networkTopologyRef=");
                builder.append(this._networkTopologyRef);
            }
            if (this._preconditions != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_preconditions=");
                builder.append(this._preconditions);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

