/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepUpdateTunnelInputBuilder {
    private Bandwidth _bandwidth;
    private ClassType _classType;
    private static List<Range<BigInteger>> _classType_range;
    private Nanotime _deadline;
    private static List<Range<BigInteger>> _deadline_range;
    private AttributeFilter _excludeAny;
    private static List<Range<BigInteger>> _excludeAny_range;
    private List<ExplicitHops> _explicitHops;
    private Short _holdPriority;
    private static List<Range<BigInteger>> _holdPriority_range;
    private InstructionId _id;
    private AttributeFilter _includeAll;
    private static List<Range<BigInteger>> _includeAll_range;
    private AttributeFilter _includeAny;
    private static List<Range<BigInteger>> _includeAny_range;
    private LinkId _linkId;
    private NetworkTopologyRef _networkTopologyRef;
    private List<InstructionId> _preconditions;
    private Short _setupPriority;
    private static List<Range<BigInteger>> _setupPriority_range;
    private String _symbolicPathName;
    private Boolean _localProtectionDesired;
    Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>();

    public PcepUpdateTunnelInputBuilder() {
    }

    public PcepUpdateTunnelInputBuilder(TunnelP2pPathCfgAttributes arg) {
        this._explicitHops = arg.getExplicitHops();
    }

    public PcepUpdateTunnelInputBuilder(BaseTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public PcepUpdateTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }

    public PcepUpdateTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public PcepUpdateTunnelInputBuilder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(TunnelAttributes arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(PcepUpdateTunnelInput base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._deadline = base.getDeadline();
        this._excludeAny = base.getExcludeAny();
        this._explicitHops = base.getExplicitHops();
        this._holdPriority = base.getHoldPriority();
        this._id = base.getId();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._linkId = base.getLinkId();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        if (base instanceof PcepUpdateTunnelInputImpl) {
            PcepUpdateTunnelInputImpl _impl = (PcepUpdateTunnelInputImpl)base;
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>(_impl.augmentation);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NetworkTopologyReference) {
            this._networkTopologyRef = ((NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof TunnelP2pPathCfgAttributes) {
            this._explicitHops = ((TunnelP2pPathCfgAttributes)arg).getExplicitHops();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._holdPriority = ((TunnelAttributes)arg).getHoldPriority();
            this._setupPriority = ((TunnelAttributes)arg).getSetupPriority();
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            isValidArg = true;
        }
        if (arg instanceof BaseTunnelInput) {
            this._linkId = ((BaseTunnelInput)arg).getLinkId();
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput) {
            this._id = ((SubmitInstructionInput)arg).getId();
            this._deadline = ((SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev130930.SubmitInstructionInput] \nbut was: " + arg);
        }
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public ClassType getClassType() {
        return this._classType;
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public List<ExplicitHops> getExplicitHops() {
        return this._explicitHops;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public InstructionId getId() {
        return this._id;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public NetworkTopologyRef getNetworkTopologyRef() {
        return this._networkTopologyRef;
    }

    public List<InstructionId> getPreconditions() {
        return this._preconditions;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public String getSymbolicPathName() {
        return this._symbolicPathName;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public <E extends Augmentation<PcepUpdateTunnelInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcepUpdateTunnelInputBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setClassType(ClassType value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._classType_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _classType_range));
            }
        }
        this._classType = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _classType_range() {
        if (_classType_range != null) return _classType_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_classType_range != null) return _classType_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _classType_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _classType_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setDeadline(Nanotime value) {
        if (value != null) {
            BigInteger _constraint = value.getValue();
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._deadline_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _deadline_range));
            }
        }
        this._deadline = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _deadline_range() {
        if (_deadline_range != null) return _deadline_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_deadline_range != null) return _deadline_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615")));
            _deadline_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _deadline_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setExcludeAny(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._excludeAny_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _excludeAny_range));
            }
        }
        this._excludeAny = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _excludeAny_range() {
        if (_excludeAny_range != null) return _excludeAny_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_excludeAny_range != null) return _excludeAny_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _excludeAny_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _excludeAny_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setExplicitHops(List<ExplicitHops> value) {
        this._explicitHops = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setHoldPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._holdPriority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _holdPriority_range));
            }
        }
        this._holdPriority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _holdPriority_range() {
        if (_holdPriority_range != null) return _holdPriority_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_holdPriority_range != null) return _holdPriority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _holdPriority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _holdPriority_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setId(InstructionId value) {
        this._id = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setIncludeAll(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._includeAll_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _includeAll_range));
            }
        }
        this._includeAll = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _includeAll_range() {
        if (_includeAll_range != null) return _includeAll_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_includeAll_range != null) return _includeAll_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _includeAll_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _includeAll_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setIncludeAny(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._includeAny_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _includeAny_range));
            }
        }
        this._includeAny = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _includeAny_range() {
        if (_includeAny_range != null) return _includeAny_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_includeAny_range != null) return _includeAny_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _includeAny_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _includeAny_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setNetworkTopologyRef(NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setPreconditions(List<InstructionId> value) {
        this._preconditions = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setSetupPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : PcepUpdateTunnelInputBuilder._setupPriority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _setupPriority_range));
            }
        }
        this._setupPriority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _setupPriority_range() {
        if (_setupPriority_range != null) return _setupPriority_range;
        Class<PcepUpdateTunnelInputBuilder> clazz = PcepUpdateTunnelInputBuilder.class;
        synchronized (PcepUpdateTunnelInputBuilder.class) {
            if (_setupPriority_range != null) return _setupPriority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _setupPriority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _setupPriority_range;
        }
    }

    public PcepUpdateTunnelInputBuilder setSymbolicPathName(String value) {
        this._symbolicPathName = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder addAugmentation(Class<? extends Augmentation<PcepUpdateTunnelInput>> augmentationType, Augmentation<PcepUpdateTunnelInput> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcepUpdateTunnelInput build() {
        return new PcepUpdateTunnelInputImpl(this);
    }

    private static final class PcepUpdateTunnelInputImpl
    implements PcepUpdateTunnelInput {
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Nanotime _deadline;
        private final AttributeFilter _excludeAny;
        private final List<ExplicitHops> _explicitHops;
        private final Short _holdPriority;
        private final InstructionId _id;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final LinkId _linkId;
        private final NetworkTopologyRef _networkTopologyRef;
        private final List<InstructionId> _preconditions;
        private final Short _setupPriority;
        private final String _symbolicPathName;
        private final Boolean _localProtectionDesired;
        private Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>();

        public Class<PcepUpdateTunnelInput> getImplementedInterface() {
            return PcepUpdateTunnelInput.class;
        }

        private PcepUpdateTunnelInputImpl(PcepUpdateTunnelInputBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._deadline = base.getDeadline();
            this._excludeAny = base.getExcludeAny();
            this._explicitHops = base.getExplicitHops();
            this._holdPriority = base.getHoldPriority();
            this._id = base.getId();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._linkId = base.getLinkId();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public ClassType getClassType() {
            return this._classType;
        }

        public Nanotime getDeadline() {
            return this._deadline;
        }

        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        public List<ExplicitHops> getExplicitHops() {
            return this._explicitHops;
        }

        public Short getHoldPriority() {
            return this._holdPriority;
        }

        public InstructionId getId() {
            return this._id;
        }

        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        public LinkId getLinkId() {
            return this._linkId;
        }

        public NetworkTopologyRef getNetworkTopologyRef() {
            return this._networkTopologyRef;
        }

        public List<InstructionId> getPreconditions() {
            return this._preconditions;
        }

        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public String getSymbolicPathName() {
            return this._symbolicPathName;
        }

        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        public <E extends Augmentation<PcepUpdateTunnelInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bandwidth == null ? 0 : this._bandwidth.hashCode());
            result = 31 * result + (this._classType == null ? 0 : this._classType.hashCode());
            result = 31 * result + (this._deadline == null ? 0 : this._deadline.hashCode());
            result = 31 * result + (this._excludeAny == null ? 0 : this._excludeAny.hashCode());
            result = 31 * result + (this._explicitHops == null ? 0 : this._explicitHops.hashCode());
            result = 31 * result + (this._holdPriority == null ? 0 : this._holdPriority.hashCode());
            result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
            result = 31 * result + (this._includeAll == null ? 0 : this._includeAll.hashCode());
            result = 31 * result + (this._includeAny == null ? 0 : this._includeAny.hashCode());
            result = 31 * result + (this._linkId == null ? 0 : this._linkId.hashCode());
            result = 31 * result + (this._networkTopologyRef == null ? 0 : this._networkTopologyRef.hashCode());
            result = 31 * result + (this._preconditions == null ? 0 : this._preconditions.hashCode());
            result = 31 * result + (this._setupPriority == null ? 0 : this._setupPriority.hashCode());
            result = 31 * result + (this._symbolicPathName == null ? 0 : this._symbolicPathName.hashCode());
            result = 31 * result + (this._localProtectionDesired == null ? 0 : this._localProtectionDesired.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepUpdateTunnelInput.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepUpdateTunnelInput other = (PcepUpdateTunnelInput)obj;
            if (this._bandwidth == null ? other.getBandwidth() != null : !this._bandwidth.equals((Object)other.getBandwidth())) {
                return false;
            }
            if (this._classType == null ? other.getClassType() != null : !this._classType.equals((Object)other.getClassType())) {
                return false;
            }
            if (this._deadline == null ? other.getDeadline() != null : !this._deadline.equals((Object)other.getDeadline())) {
                return false;
            }
            if (this._excludeAny == null ? other.getExcludeAny() != null : !this._excludeAny.equals((Object)other.getExcludeAny())) {
                return false;
            }
            if (this._explicitHops == null ? other.getExplicitHops() != null : !this._explicitHops.equals(other.getExplicitHops())) {
                return false;
            }
            if (this._holdPriority == null ? other.getHoldPriority() != null : !this._holdPriority.equals(other.getHoldPriority())) {
                return false;
            }
            if (this._id == null ? other.getId() != null : !this._id.equals((Object)other.getId())) {
                return false;
            }
            if (this._includeAll == null ? other.getIncludeAll() != null : !this._includeAll.equals((Object)other.getIncludeAll())) {
                return false;
            }
            if (this._includeAny == null ? other.getIncludeAny() != null : !this._includeAny.equals((Object)other.getIncludeAny())) {
                return false;
            }
            if (this._linkId == null ? other.getLinkId() != null : !this._linkId.equals((Object)other.getLinkId())) {
                return false;
            }
            if (this._networkTopologyRef == null ? other.getNetworkTopologyRef() != null : !this._networkTopologyRef.equals((Object)other.getNetworkTopologyRef())) {
                return false;
            }
            if (this._preconditions == null ? other.getPreconditions() != null : !this._preconditions.equals(other.getPreconditions())) {
                return false;
            }
            if (this._setupPriority == null ? other.getSetupPriority() != null : !this._setupPriority.equals(other.getSetupPriority())) {
                return false;
            }
            if (this._symbolicPathName == null ? other.getSymbolicPathName() != null : !this._symbolicPathName.equals(other.getSymbolicPathName())) {
                return false;
            }
            if (this._localProtectionDesired == null ? other.isLocalProtectionDesired() != null : !this._localProtectionDesired.equals(other.isLocalProtectionDesired())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepUpdateTunnelInputImpl otherImpl = (PcepUpdateTunnelInputImpl)obj;
                if (this.augmentation == null ? otherImpl.augmentation != null : !this.augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("PcepUpdateTunnelInput [");
            boolean first = true;
            if (this._bandwidth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bandwidth=");
                builder.append(this._bandwidth);
            }
            if (this._classType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classType=");
                builder.append(this._classType);
            }
            if (this._deadline != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadline=");
                builder.append(this._deadline);
            }
            if (this._excludeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_excludeAny=");
                builder.append(this._excludeAny);
            }
            if (this._explicitHops != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_explicitHops=");
                builder.append(this._explicitHops);
            }
            if (this._holdPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_holdPriority=");
                builder.append(this._holdPriority);
            }
            if (this._id != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_id=");
                builder.append(this._id);
            }
            if (this._includeAll != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAll=");
                builder.append(this._includeAll);
            }
            if (this._includeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAny=");
                builder.append(this._includeAny);
            }
            if (this._linkId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_linkId=");
                builder.append(this._linkId);
            }
            if (this._networkTopologyRef != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_networkTopologyRef=");
                builder.append(this._networkTopologyRef);
            }
            if (this._preconditions != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_preconditions=");
                builder.append(this._preconditions);
            }
            if (this._setupPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_setupPriority=");
                builder.append(this._setupPriority);
            }
            if (this._symbolicPathName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_symbolicPathName=");
                builder.append(this._symbolicPathName);
            }
            if (this._localProtectionDesired != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localProtectionDesired=");
                builder.append(this._localProtectionDesired);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

