/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Link1Builder {
    private Bandwidth _bandwidth;
    private ClassType _classType;
    private static List<Range<BigInteger>> _classType_range;
    private AttributeFilter _excludeAny;
    private static List<Range<BigInteger>> _excludeAny_range;
    private Short _holdPriority;
    private static List<Range<BigInteger>> _holdPriority_range;
    private AttributeFilter _includeAll;
    private static List<Range<BigInteger>> _includeAll_range;
    private AttributeFilter _includeAny;
    private static List<Range<BigInteger>> _includeAny_range;
    private Short _setupPriority;
    private static List<Range<BigInteger>> _setupPriority_range;
    private String _symbolicPathName;
    private Boolean _localProtectionDesired;

    public Link1Builder() {
    }

    public Link1Builder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(TunnelAttributes arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(Link1 base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
        this._localProtectionDesired = base.isLocalProtectionDesired();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._holdPriority = ((TunnelAttributes)arg).getHoldPriority();
            this._setupPriority = ((TunnelAttributes)arg).getSetupPriority();
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes] \nbut was: " + arg);
        }
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public ClassType getClassType() {
        return this._classType;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public String getSymbolicPathName() {
        return this._symbolicPathName;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Link1Builder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public Link1Builder setClassType(ClassType value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue().shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : Link1Builder._classType_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _classType_range));
            }
        }
        this._classType = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _classType_range() {
        if (_classType_range != null) return _classType_range;
        Class<Link1Builder> clazz = Link1Builder.class;
        synchronized (Link1Builder.class) {
            if (_classType_range != null) return _classType_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ONE, (Comparable)BigInteger.valueOf(7L)));
            _classType_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _classType_range;
        }
    }

    public Link1Builder setExcludeAny(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : Link1Builder._excludeAny_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _excludeAny_range));
            }
        }
        this._excludeAny = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _excludeAny_range() {
        if (_excludeAny_range != null) return _excludeAny_range;
        Class<Link1Builder> clazz = Link1Builder.class;
        synchronized (Link1Builder.class) {
            if (_excludeAny_range != null) return _excludeAny_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _excludeAny_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _excludeAny_range;
        }
    }

    public Link1Builder setHoldPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : Link1Builder._holdPriority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _holdPriority_range));
            }
        }
        this._holdPriority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _holdPriority_range() {
        if (_holdPriority_range != null) return _holdPriority_range;
        Class<Link1Builder> clazz = Link1Builder.class;
        synchronized (Link1Builder.class) {
            if (_holdPriority_range != null) return _holdPriority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _holdPriority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _holdPriority_range;
        }
    }

    public Link1Builder setIncludeAll(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : Link1Builder._includeAll_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _includeAll_range));
            }
        }
        this._includeAll = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _includeAll_range() {
        if (_includeAll_range != null) return _includeAll_range;
        Class<Link1Builder> clazz = Link1Builder.class;
        synchronized (Link1Builder.class) {
            if (_includeAll_range != null) return _includeAll_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _includeAll_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _includeAll_range;
        }
    }

    public Link1Builder setIncludeAny(AttributeFilter value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.getValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : Link1Builder._includeAny_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _includeAny_range));
            }
        }
        this._includeAny = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _includeAny_range() {
        if (_includeAny_range != null) return _includeAny_range;
        Class<Link1Builder> clazz = Link1Builder.class;
        synchronized (Link1Builder.class) {
            if (_includeAny_range != null) return _includeAny_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(0xFFFFFFFFL)));
            _includeAny_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _includeAny_range;
        }
    }

    public Link1Builder setSetupPriority(Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value.shortValue());
            boolean isValidRange = false;
            for (Range<BigInteger> r : Link1Builder._setupPriority_range()) {
                if (!r.contains((Comparable)_constraint)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _setupPriority_range));
            }
        }
        this._setupPriority = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Range<BigInteger>> _setupPriority_range() {
        if (_setupPriority_range != null) return _setupPriority_range;
        Class<Link1Builder> clazz = Link1Builder.class;
        synchronized (Link1Builder.class) {
            if (_setupPriority_range != null) return _setupPriority_range;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Range.closed((Comparable)BigInteger.ZERO, (Comparable)BigInteger.valueOf(255L)));
            _setupPriority_range = builder.build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _setupPriority_range;
        }
    }

    public Link1Builder setSymbolicPathName(String value) {
        this._symbolicPathName = value;
        return this;
    }

    public Link1Builder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl
    implements Link1 {
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final AttributeFilter _excludeAny;
        private final Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Short _setupPriority;
        private final String _symbolicPathName;
        private final Boolean _localProtectionDesired;

        public Class<Link1> getImplementedInterface() {
            return Link1.class;
        }

        private Link1Impl(Link1Builder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
            this._localProtectionDesired = base.isLocalProtectionDesired();
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public ClassType getClassType() {
            return this._classType;
        }

        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        public Short getHoldPriority() {
            return this._holdPriority;
        }

        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public String getSymbolicPathName() {
            return this._symbolicPathName;
        }

        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._bandwidth == null ? 0 : this._bandwidth.hashCode());
            result = 31 * result + (this._classType == null ? 0 : this._classType.hashCode());
            result = 31 * result + (this._excludeAny == null ? 0 : this._excludeAny.hashCode());
            result = 31 * result + (this._holdPriority == null ? 0 : this._holdPriority.hashCode());
            result = 31 * result + (this._includeAll == null ? 0 : this._includeAll.hashCode());
            result = 31 * result + (this._includeAny == null ? 0 : this._includeAny.hashCode());
            result = 31 * result + (this._setupPriority == null ? 0 : this._setupPriority.hashCode());
            result = 31 * result + (this._symbolicPathName == null ? 0 : this._symbolicPathName.hashCode());
            result = 31 * result + (this._localProtectionDesired == null ? 0 : this._localProtectionDesired.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Link1.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Link1 other = (Link1)obj;
            if (this._bandwidth == null ? other.getBandwidth() != null : !this._bandwidth.equals((Object)other.getBandwidth())) {
                return false;
            }
            if (this._classType == null ? other.getClassType() != null : !this._classType.equals((Object)other.getClassType())) {
                return false;
            }
            if (this._excludeAny == null ? other.getExcludeAny() != null : !this._excludeAny.equals((Object)other.getExcludeAny())) {
                return false;
            }
            if (this._holdPriority == null ? other.getHoldPriority() != null : !this._holdPriority.equals(other.getHoldPriority())) {
                return false;
            }
            if (this._includeAll == null ? other.getIncludeAll() != null : !this._includeAll.equals((Object)other.getIncludeAll())) {
                return false;
            }
            if (this._includeAny == null ? other.getIncludeAny() != null : !this._includeAny.equals((Object)other.getIncludeAny())) {
                return false;
            }
            if (this._setupPriority == null ? other.getSetupPriority() != null : !this._setupPriority.equals(other.getSetupPriority())) {
                return false;
            }
            if (this._symbolicPathName == null ? other.getSymbolicPathName() != null : !this._symbolicPathName.equals(other.getSymbolicPathName())) {
                return false;
            }
            return !(this._localProtectionDesired == null ? other.isLocalProtectionDesired() != null : !this._localProtectionDesired.equals(other.isLocalProtectionDesired()));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Link1 [");
            boolean first = true;
            if (this._bandwidth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bandwidth=");
                builder.append(this._bandwidth);
            }
            if (this._classType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classType=");
                builder.append(this._classType);
            }
            if (this._excludeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_excludeAny=");
                builder.append(this._excludeAny);
            }
            if (this._holdPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_holdPriority=");
                builder.append(this._holdPriority);
            }
            if (this._includeAll != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAll=");
                builder.append(this._includeAll);
            }
            if (this._includeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAny=");
                builder.append(this._includeAny);
            }
            if (this._setupPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_setupPriority=");
                builder.append(this._setupPriority);
            }
            if (this._symbolicPathName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_symbolicPathName=");
                builder.append(this._symbolicPathName);
            }
            if (this._localProtectionDesired != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localProtectionDesired=");
                builder.append(this._localProtectionDesired);
            }
            return builder.append(']').toString();
        }
    }
}

