package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;topology-tunnel-pcep-programming&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/topology-tunnel-pcep-programming.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container input {
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     container destination {
 *         leaf node {
 *             type node-ref;
 *         }
 *         leaf tp {
 *             type tp-ref;
 *         }
 *         uses tp-reference;
 *     }
 *     container source {
 *         leaf node {
 *             type node-ref;
 *         }
 *         leaf tp {
 *             type tp-ref;
 *         }
 *         uses tp-reference;
 *     }
 *     list explicit-hops {
 *         key "order"
 *         leaf order {
 *             type uint32;
 *         }
 *         leaf loose {
 *             type boolean;
 *         }
 *         uses tunnel-p2p-path-hops;
 *     }
 *     leaf symbolic-path-name {
 *         type string;
 *     }
 *     leaf class-type {
 *         type class-type;
 *     }
 *     leaf bandwidth {
 *         type bandwidth;
 *     }
 *     leaf hold-priority {
 *         type uint8;
 *     }
 *     leaf setup-priority {
 *         type uint8;
 *     }
 *     leaf local-protection-desired {
 *         type boolean;
 *     }
 *     leaf include-any {
 *         type attribute-filter;
 *     }
 *     leaf exclude-any {
 *         type attribute-filter;
 *     }
 *     leaf include-all {
 *         type attribute-filter;
 *     }
 *     uses tunnel-p2p-path-cfg-attributes;
 *     uses tunnel-pcep-link-cfg-attributes;
 *     uses create-p2p-tunnel-input;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;topology-tunnel-pcep-programming/pcep-create-p2p-tunnel/input&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInputBuilder
 *
 */
public interface PcepCreateP2pTunnelInput
    extends
    TunnelP2pPathCfgAttributes,
    TunnelPcepLinkCfgAttributes,
    CreateP2pTunnelInput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep:programming","2013-10-30","input"));


}

