package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;topology-tunnel-pcep-programming&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/topology-tunnel-pcep-programming.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container input {
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     leaf link-id {
 *         type link-id;
 *     }
 *     list explicit-hops {
 *         key "order"
 *         leaf order {
 *             type uint32;
 *         }
 *         leaf loose {
 *             type boolean;
 *         }
 *         uses tunnel-p2p-path-hops;
 *     }
 *     leaf symbolic-path-name {
 *         type string;
 *     }
 *     leaf class-type {
 *         type class-type;
 *     }
 *     leaf bandwidth {
 *         type bandwidth;
 *     }
 *     leaf hold-priority {
 *         type uint8;
 *     }
 *     leaf setup-priority {
 *         type uint8;
 *     }
 *     leaf local-protection-desired {
 *         type boolean;
 *     }
 *     leaf include-any {
 *         type attribute-filter;
 *     }
 *     leaf exclude-any {
 *         type attribute-filter;
 *     }
 *     leaf include-all {
 *         type attribute-filter;
 *     }
 *     uses tunnel-p2p-path-cfg-attributes;
 *     uses base-tunnel-input;
 *     uses tunnel-pcep-link-cfg-attributes;
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;topology-tunnel-pcep-programming/pcep-update-tunnel/input&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInputBuilder
 *
 */
public interface PcepUpdateTunnelInput
    extends
    TunnelP2pPathCfgAttributes,
    BaseTunnelInput,
    TunnelPcepLinkCfgAttributes,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep:programming","2013-10-30","input"));


}

