package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;


/**
 * Interface for implementing the following YANG RPCs defined in module &lt;b&gt;topology-tunnel-pcep-programming&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/topology-tunnel-pcep-programming.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * rpc pcep-create-p2p-tunnel {
 *     input {
 *         leaf network-topology-ref {
 *             type network-topology-ref;
 *         }
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *         container destination {
 *             leaf node {
 *                 type node-ref;
 *             }
 *             leaf tp {
 *                 type tp-ref;
 *             }
 *             uses tp-reference;
 *         }
 *         container source {
 *             leaf node {
 *                 type node-ref;
 *             }
 *             leaf tp {
 *                 type tp-ref;
 *             }
 *             uses tp-reference;
 *         }
 *         list explicit-hops {
 *             key "order"
 *             leaf order {
 *                 type uint32;
 *             }
 *             leaf loose {
 *                 type boolean;
 *             }
 *             uses tunnel-p2p-path-hops;
 *         }
 *         leaf symbolic-path-name {
 *             type string;
 *         }
 *         leaf class-type {
 *             type class-type;
 *         }
 *         leaf bandwidth {
 *             type bandwidth;
 *         }
 *         leaf hold-priority {
 *             type uint8;
 *         }
 *         leaf setup-priority {
 *             type uint8;
 *         }
 *         leaf local-protection-desired {
 *             type boolean;
 *         }
 *         leaf include-any {
 *             type attribute-filter;
 *         }
 *         leaf exclude-any {
 *             type attribute-filter;
 *         }
 *         leaf include-all {
 *             type attribute-filter;
 *         }
 *     }
 *     
 *     output {
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *         leaf link-id {
 *             type link-id;
 *         }
 *     }
 *     status CURRENT;
 * }
 * rpc pcep-destroy-tunnel {
 *     input {
 *         leaf network-topology-ref {
 *             type network-topology-ref;
 *         }
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *         leaf link-id {
 *             type link-id;
 *         }
 *     }
 *     
 *     output {
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     status CURRENT;
 * }
 * rpc pcep-update-tunnel {
 *     input {
 *         leaf network-topology-ref {
 *             type network-topology-ref;
 *         }
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *         leaf link-id {
 *             type link-id;
 *         }
 *         list explicit-hops {
 *             key "order"
 *             leaf order {
 *                 type uint32;
 *             }
 *             leaf loose {
 *                 type boolean;
 *             }
 *             uses tunnel-p2p-path-hops;
 *         }
 *         leaf symbolic-path-name {
 *             type string;
 *         }
 *         leaf class-type {
 *             type class-type;
 *         }
 *         leaf bandwidth {
 *             type bandwidth;
 *         }
 *         leaf hold-priority {
 *             type uint8;
 *         }
 *         leaf setup-priority {
 *             type uint8;
 *         }
 *         leaf local-protection-desired {
 *             type boolean;
 *         }
 *         leaf include-any {
 *             type attribute-filter;
 *         }
 *         leaf exclude-any {
 *             type attribute-filter;
 *         }
 *         leaf include-all {
 *             type attribute-filter;
 *         }
 *     }
 *     
 *     output {
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *     status CURRENT;
 * }
 * &lt;/pre&gt;
 *
 */
public interface TopologyTunnelPcepProgrammingService
    extends
    RpcService
{




    Future<RpcResult<PcepCreateP2pTunnelOutput>> pcepCreateP2pTunnel(PcepCreateP2pTunnelInput input);
    
    Future<RpcResult<PcepDestroyTunnelOutput>> pcepDestroyTunnel(PcepDestroyTunnelInput input);
    
    Future<RpcResult<PcepUpdateTunnelOutput>> pcepUpdateTunnel(PcepUpdateTunnelInput input);

}

