package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilter;
import com.google.common.collect.Range;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.List;
import java.math.BigInteger;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1
 *
 */
public class Link1Builder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private AttributeFilter _excludeAny;
    private java.lang.Short _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private java.lang.Short _setupPriority;
    private java.lang.String _symbolicPathName;
    private java.lang.Boolean _localProtectionDesired;


    public Link1Builder() {
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(Link1 base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
        this._localProtectionDesired = base.isLocalProtectionDesired();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters) {
            this._includeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes) {
            this._holdPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes)arg).getHoldPriority();
            this._setupPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes)arg).getSetupPriority();
            this._localProtectionDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes)arg).isLocalProtectionDesired();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    public java.lang.Short getHoldPriority() {
        return _holdPriority;
    }
    
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    public java.lang.Short getSetupPriority() {
        return _setupPriority;
    }
    
    public java.lang.String getSymbolicPathName() {
        return _symbolicPathName;
    }
    
    public java.lang.Boolean isLocalProtectionDesired() {
        return _localProtectionDesired;
    }

    public Link1Builder setBandwidth(Bandwidth value) {
        if (value != null) {
        }
        this._bandwidth = value;
        return this;
    }
    
    private static void checkClassTypeRange(final short value) {
        if (value >= (short)1 && value <= (short)7) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[1‥7]].", value));
    }
    
    public Link1Builder setClassType(ClassType value) {
        if (value != null) {
            checkClassTypeRange(value.getValue());
        }
        this._classType = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _classType_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ONE, BigInteger.valueOf(7L)));
        return ret;
    }
    
    private static void checkExcludeAnyRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
    }
    
    public Link1Builder setExcludeAny(AttributeFilter value) {
        if (value != null) {
            checkExcludeAnyRange(value.getValue());
        }
        this._excludeAny = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _excludeAny_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(4294967295L)));
        return ret;
    }
    
    private static void checkHoldPriorityRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public Link1Builder setHoldPriority(java.lang.Short value) {
        if (value != null) {
            checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _holdPriority_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    private static void checkIncludeAllRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
    }
    
    public Link1Builder setIncludeAll(AttributeFilter value) {
        if (value != null) {
            checkIncludeAllRange(value.getValue());
        }
        this._includeAll = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _includeAll_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(4294967295L)));
        return ret;
    }
    
    private static void checkIncludeAnyRange(final long value) {
        if (value >= 0L && value <= 4294967295L) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
    }
    
    public Link1Builder setIncludeAny(AttributeFilter value) {
        if (value != null) {
            checkIncludeAnyRange(value.getValue());
        }
        this._includeAny = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _includeAny_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(4294967295L)));
        return ret;
    }
    
    private static void checkSetupPriorityRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥255]].", value));
    }
    
    public Link1Builder setSetupPriority(java.lang.Short value) {
        if (value != null) {
            checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }
    /**
     * @deprecated This method is slated for removal in a future release. See BUG-1485 for details.
     */
    @Deprecated
    public static List<Range<BigInteger>> _setupPriority_range() {
        final List<Range<BigInteger>> ret = new java.util.ArrayList<>(1);
        ret.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
        return ret;
    }
    
    public Link1Builder setSymbolicPathName(java.lang.String value) {
        this._symbolicPathName = value;
        return this;
    }
    
    public Link1Builder setLocalProtectionDesired(java.lang.Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl implements Link1 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1.class;
        }

        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final AttributeFilter _excludeAny;
        private final java.lang.Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final java.lang.Short _setupPriority;
        private final java.lang.String _symbolicPathName;
        private final java.lang.Boolean _localProtectionDesired;


        private Link1Impl(Link1Builder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
            this._localProtectionDesired = base.isLocalProtectionDesired();
        }

        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public java.lang.Short getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public java.lang.Short getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public java.lang.String getSymbolicPathName() {
            return _symbolicPathName;
        }
        
        @Override
        public java.lang.Boolean isLocalProtectionDesired() {
            return _localProtectionDesired;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_bandwidth == null) ? 0 : _bandwidth.hashCode());
            result = prime * result + ((_classType == null) ? 0 : _classType.hashCode());
            result = prime * result + ((_excludeAny == null) ? 0 : _excludeAny.hashCode());
            result = prime * result + ((_holdPriority == null) ? 0 : _holdPriority.hashCode());
            result = prime * result + ((_includeAll == null) ? 0 : _includeAll.hashCode());
            result = prime * result + ((_includeAny == null) ? 0 : _includeAny.hashCode());
            result = prime * result + ((_setupPriority == null) ? 0 : _setupPriority.hashCode());
            result = prime * result + ((_symbolicPathName == null) ? 0 : _symbolicPathName.hashCode());
            result = prime * result + ((_localProtectionDesired == null) ? 0 : _localProtectionDesired.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1)obj;
            if (_bandwidth == null) {
                if (other.getBandwidth() != null) {
                    return false;
                }
            } else if(!_bandwidth.equals(other.getBandwidth())) {
                return false;
            }
            if (_classType == null) {
                if (other.getClassType() != null) {
                    return false;
                }
            } else if(!_classType.equals(other.getClassType())) {
                return false;
            }
            if (_excludeAny == null) {
                if (other.getExcludeAny() != null) {
                    return false;
                }
            } else if(!_excludeAny.equals(other.getExcludeAny())) {
                return false;
            }
            if (_holdPriority == null) {
                if (other.getHoldPriority() != null) {
                    return false;
                }
            } else if(!_holdPriority.equals(other.getHoldPriority())) {
                return false;
            }
            if (_includeAll == null) {
                if (other.getIncludeAll() != null) {
                    return false;
                }
            } else if(!_includeAll.equals(other.getIncludeAll())) {
                return false;
            }
            if (_includeAny == null) {
                if (other.getIncludeAny() != null) {
                    return false;
                }
            } else if(!_includeAny.equals(other.getIncludeAny())) {
                return false;
            }
            if (_setupPriority == null) {
                if (other.getSetupPriority() != null) {
                    return false;
                }
            } else if(!_setupPriority.equals(other.getSetupPriority())) {
                return false;
            }
            if (_symbolicPathName == null) {
                if (other.getSymbolicPathName() != null) {
                    return false;
                }
            } else if(!_symbolicPathName.equals(other.getSymbolicPathName())) {
                return false;
            }
            if (_localProtectionDesired == null) {
                if (other.isLocalProtectionDesired() != null) {
                    return false;
                }
            } else if(!_localProtectionDesired.equals(other.isLocalProtectionDesired())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Link1 [");
            boolean first = true;
        
            if (_bandwidth != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_bandwidth=");
                builder.append(_bandwidth);
             }
            if (_classType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_classType=");
                builder.append(_classType);
             }
            if (_excludeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_excludeAny=");
                builder.append(_excludeAny);
             }
            if (_holdPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_holdPriority=");
                builder.append(_holdPriority);
             }
            if (_includeAll != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAll=");
                builder.append(_includeAll);
             }
            if (_includeAny != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_includeAny=");
                builder.append(_includeAny);
             }
            if (_setupPriority != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_setupPriority=");
                builder.append(_setupPriority);
             }
            if (_symbolicPathName != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_symbolicPathName=");
                builder.append(_symbolicPathName);
             }
            if (_localProtectionDesired != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_localProtectionDesired=");
                builder.append(_localProtectionDesired);
             }
            return builder.append(']').toString();
        }
    }

}
