package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.record.route.subobjects.SubobjectType;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1
 *
 */
public class ReportedHops1Builder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1> {

    private SubobjectType _subobjectType;
    private java.lang.Boolean _protectionAvailable;
    private java.lang.Boolean _protectionInUse;


    public ReportedHops1Builder() {
    }
    public ReportedHops1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects arg) {
        this._protectionAvailable = arg.isProtectionAvailable();
        this._protectionInUse = arg.isProtectionInUse();
        this._subobjectType = arg.getSubobjectType();
    }

    public ReportedHops1Builder(ReportedHops1 base) {
        this._subobjectType = base.getSubobjectType();
        this._protectionAvailable = base.isProtectionAvailable();
        this._protectionInUse = base.isProtectionInUse();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects) {
            this._protectionAvailable = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects)arg).isProtectionAvailable();
            this._protectionInUse = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects)arg).isProtectionInUse();
            this._subobjectType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects)arg).getSubobjectType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.RecordRouteSubobjects] \n" +
              "but was: " + arg
            );
        }
    }

    public SubobjectType getSubobjectType() {
        return _subobjectType;
    }
    
    public java.lang.Boolean isProtectionAvailable() {
        return _protectionAvailable;
    }
    
    public java.lang.Boolean isProtectionInUse() {
        return _protectionInUse;
    }

    public ReportedHops1Builder setSubobjectType(SubobjectType value) {
        this._subobjectType = value;
        return this;
    }
    
    public ReportedHops1Builder setProtectionAvailable(java.lang.Boolean value) {
        this._protectionAvailable = value;
        return this;
    }
    
    public ReportedHops1Builder setProtectionInUse(java.lang.Boolean value) {
        this._protectionInUse = value;
        return this;
    }

    public ReportedHops1 build() {
        return new ReportedHops1Impl(this);
    }

    private static final class ReportedHops1Impl implements ReportedHops1 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1.class;
        }

        private final SubobjectType _subobjectType;
        private final java.lang.Boolean _protectionAvailable;
        private final java.lang.Boolean _protectionInUse;


        private ReportedHops1Impl(ReportedHops1Builder base) {
            this._subobjectType = base.getSubobjectType();
            this._protectionAvailable = base.isProtectionAvailable();
            this._protectionInUse = base.isProtectionInUse();
        }

        @Override
        public SubobjectType getSubobjectType() {
            return _subobjectType;
        }
        
        @Override
        public java.lang.Boolean isProtectionAvailable() {
            return _protectionAvailable;
        }
        
        @Override
        public java.lang.Boolean isProtectionInUse() {
            return _protectionInUse;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_subobjectType == null) ? 0 : _subobjectType.hashCode());
            result = prime * result + ((_protectionAvailable == null) ? 0 : _protectionAvailable.hashCode());
            result = prime * result + ((_protectionInUse == null) ? 0 : _protectionInUse.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1)obj;
            if (_subobjectType == null) {
                if (other.getSubobjectType() != null) {
                    return false;
                }
            } else if(!_subobjectType.equals(other.getSubobjectType())) {
                return false;
            }
            if (_protectionAvailable == null) {
                if (other.isProtectionAvailable() != null) {
                    return false;
                }
            } else if(!_protectionAvailable.equals(other.isProtectionAvailable())) {
                return false;
            }
            if (_protectionInUse == null) {
                if (other.isProtectionInUse() != null) {
                    return false;
                }
            } else if(!_protectionInUse.equals(other.isProtectionInUse())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("ReportedHops1 [");
            boolean first = true;
        
            if (_subobjectType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_subobjectType=");
                builder.append(_subobjectType);
             }
            if (_protectionAvailable != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protectionAvailable=");
                builder.append(_protectionAvailable);
             }
            if (_protectionInUse != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_protectionInUse=");
                builder.append(_protectionInUse);
             }
            return builder.append(']').toString();
        }
    }

}
