package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev130820.TunnelAttributes;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;


/**
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;topology-tunnel-pcep&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/topology-tunnel-pcep.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * grouping tunnel-pcep-link-cfg-attributes {
 *     leaf symbolic-path-name {
 *         type string;
 *     }
 *     leaf class-type {
 *         type class-type;
 *     }
 *     leaf bandwidth {
 *         type bandwidth;
 *     }
 *     leaf hold-priority {
 *         type uint8;
 *     }
 *     leaf setup-priority {
 *         type uint8;
 *     }
 *     leaf local-protection-desired {
 *         type boolean;
 *     }
 *     leaf include-any {
 *         type attribute-filter;
 *     }
 *     leaf exclude-any {
 *         type attribute-filter;
 *     }
 *     leaf include-all {
 *         type attribute-filter;
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;topology-tunnel-pcep/tunnel-pcep-link-cfg-attributes&lt;/i&gt;
 *
 */
public interface TunnelPcepLinkCfgAttributes
    extends
    DataObject,
    TunnelAttributes
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep","2013-08-20","tunnel-pcep-link-cfg-attributes"));

    java.lang.String getSymbolicPathName();
    
    ClassType getClassType();
    
    Bandwidth getBandwidth();

}

