package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Destination;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Source;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput
 *
 */
public class PcepCreateP2pTunnelInputBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Nanotime _deadline;
    private Destination _destination;
    private AttributeFilter _excludeAny;
    private List<ExplicitHops> _explicitHops;
    private java.lang.Short _holdPriority;
    private InstructionId _id;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private NetworkTopologyRef _networkTopologyRef;
    private List<InstructionId> _preconditions;
    private java.lang.String _sessionName;
    private java.lang.Short _setupPriority;
    private Source _source;
    private java.lang.String _symbolicPathName;
    private java.lang.Boolean _labelRecordingDesired;
    private java.lang.Boolean _localProtectionDesired;
    private java.lang.Boolean _seStyleDesired;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> augmentation = Collections.emptyMap();

    public PcepCreateP2pTunnelInputBuilder() {
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput arg) {
        this._destination = arg.getDestination();
        this._source = arg.getSource();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public PcepCreateP2pTunnelInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes arg) {
        this._explicitHops = arg.getExplicitHops();
    }

    public PcepCreateP2pTunnelInputBuilder(PcepCreateP2pTunnelInput base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._deadline = base.getDeadline();
        this._destination = base.getDestination();
        this._excludeAny = base.getExcludeAny();
        this._explicitHops = base.getExplicitHops();
        this._holdPriority = base.getHoldPriority();
        this._id = base.getId();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._source = base.getSource();
        this._symbolicPathName = base.getSymbolicPathName();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._seStyleDesired = base.isSeStyleDesired();
        if (base instanceof PcepCreateP2pTunnelInputImpl) {
            PcepCreateP2pTunnelInputImpl impl = (PcepCreateP2pTunnelInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput) {
            this._destination = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput)arg).getDestination();
            this._source = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput)arg).getSource();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference) {
            this._networkTopologyRef = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters) {
            this._includeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput) {
            this._id = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput)arg).getId();
            this._deadline = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority) {
            this._holdPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority)arg).getHoldPriority();
            this._setupPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes) {
            this._explicitHops = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes)arg).getExplicitHops();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes) {
            this._localProtectionDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.CreateP2pTunnelInput, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public Nanotime getDeadline() {
        return _deadline;
    }
    
    public Destination getDestination() {
        return _destination;
    }
    
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    public List<ExplicitHops> getExplicitHops() {
        return _explicitHops;
    }
    
    public java.lang.Short getHoldPriority() {
        return _holdPriority;
    }
    
    public InstructionId getId() {
        return _id;
    }
    
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    public List<InstructionId> getPreconditions() {
        return _preconditions;
    }
    
    public java.lang.String getSessionName() {
        return _sessionName;
    }
    
    public java.lang.Short getSetupPriority() {
        return _setupPriority;
    }
    
    public Source getSource() {
        return _source;
    }
    
    public java.lang.String getSymbolicPathName() {
        return _symbolicPathName;
    }
    
    public java.lang.Boolean isLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    public java.lang.Boolean isLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    public java.lang.Boolean isSeStyleDesired() {
        return _seStyleDesired;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public PcepCreateP2pTunnelInputBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setDeadline(final Nanotime value) {
        this._deadline = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setDestination(final Destination value) {
        this._destination = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setExplicitHops(final List<ExplicitHops> value) {
        this._explicitHops = value;
        return this;
    }
    
     
     private static void checkHoldPriorityRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
     }
    
    public PcepCreateP2pTunnelInputBuilder setHoldPriority(final java.lang.Short value) {
    if (value != null) {
        checkHoldPriorityRange(value);
    }
        this._holdPriority = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setId(final InstructionId value) {
        this._id = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setPreconditions(final List<InstructionId> value) {
        this._preconditions = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setSessionName(final java.lang.String value) {
        this._sessionName = value;
        return this;
    }
    
     
     private static void checkSetupPriorityRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
     }
    
    public PcepCreateP2pTunnelInputBuilder setSetupPriority(final java.lang.Short value) {
    if (value != null) {
        checkSetupPriorityRange(value);
    }
        this._setupPriority = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setSource(final Source value) {
        this._source = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setSymbolicPathName(final java.lang.String value) {
        this._symbolicPathName = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setLabelRecordingDesired(final java.lang.Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setLocalProtectionDesired(final java.lang.Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
     
    public PcepCreateP2pTunnelInputBuilder setSeStyleDesired(final java.lang.Boolean value) {
        this._seStyleDesired = value;
        return this;
    }
    
    public PcepCreateP2pTunnelInputBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public PcepCreateP2pTunnelInputBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepCreateP2pTunnelInput build() {
        return new PcepCreateP2pTunnelInputImpl(this);
    }

    private static final class PcepCreateP2pTunnelInputImpl implements PcepCreateP2pTunnelInput {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput.class;
        }

        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Nanotime _deadline;
        private final Destination _destination;
        private final AttributeFilter _excludeAny;
        private final List<ExplicitHops> _explicitHops;
        private final java.lang.Short _holdPriority;
        private final InstructionId _id;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final NetworkTopologyRef _networkTopologyRef;
        private final List<InstructionId> _preconditions;
        private final java.lang.String _sessionName;
        private final java.lang.Short _setupPriority;
        private final Source _source;
        private final java.lang.String _symbolicPathName;
        private final java.lang.Boolean _labelRecordingDesired;
        private final java.lang.Boolean _localProtectionDesired;
        private final java.lang.Boolean _seStyleDesired;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> augmentation = Collections.emptyMap();

        private PcepCreateP2pTunnelInputImpl(PcepCreateP2pTunnelInputBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._deadline = base.getDeadline();
            this._destination = base.getDestination();
            this._excludeAny = base.getExcludeAny();
            this._explicitHops = base.getExplicitHops();
            this._holdPriority = base.getHoldPriority();
            this._id = base.getId();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._source = base.getSource();
            this._symbolicPathName = base.getSymbolicPathName();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._seStyleDesired = base.isSeStyleDesired();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Nanotime getDeadline() {
            return _deadline;
        }
        
        @Override
        public Destination getDestination() {
            return _destination;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public List<ExplicitHops> getExplicitHops() {
            return _explicitHops;
        }
        
        @Override
        public java.lang.Short getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public InstructionId getId() {
            return _id;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public List<InstructionId> getPreconditions() {
            return _preconditions;
        }
        
        @Override
        public java.lang.String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public java.lang.Short getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public Source getSource() {
            return _source;
        }
        
        @Override
        public java.lang.String getSymbolicPathName() {
            return _symbolicPathName;
        }
        
        @Override
        public java.lang.Boolean isLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public java.lang.Boolean isLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public java.lang.Boolean isSeStyleDesired() {
            return _seStyleDesired;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bandwidth);
            result = prime * result + Objects.hashCode(_classType);
            result = prime * result + Objects.hashCode(_deadline);
            result = prime * result + Objects.hashCode(_destination);
            result = prime * result + Objects.hashCode(_excludeAny);
            result = prime * result + Objects.hashCode(_explicitHops);
            result = prime * result + Objects.hashCode(_holdPriority);
            result = prime * result + Objects.hashCode(_id);
            result = prime * result + Objects.hashCode(_includeAll);
            result = prime * result + Objects.hashCode(_includeAny);
            result = prime * result + Objects.hashCode(_networkTopologyRef);
            result = prime * result + Objects.hashCode(_preconditions);
            result = prime * result + Objects.hashCode(_sessionName);
            result = prime * result + Objects.hashCode(_setupPriority);
            result = prime * result + Objects.hashCode(_source);
            result = prime * result + Objects.hashCode(_symbolicPathName);
            result = prime * result + Objects.hashCode(_labelRecordingDesired);
            result = prime * result + Objects.hashCode(_localProtectionDesired);
            result = prime * result + Objects.hashCode(_seStyleDesired);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput)obj;
            if (!Objects.equals(_bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(_classType, other.getClassType())) {
                return false;
            }
            if (!Objects.equals(_deadline, other.getDeadline())) {
                return false;
            }
            if (!Objects.equals(_destination, other.getDestination())) {
                return false;
            }
            if (!Objects.equals(_excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(_explicitHops, other.getExplicitHops())) {
                return false;
            }
            if (!Objects.equals(_holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(_id, other.getId())) {
                return false;
            }
            if (!Objects.equals(_includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(_includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(_networkTopologyRef, other.getNetworkTopologyRef())) {
                return false;
            }
            if (!Objects.equals(_preconditions, other.getPreconditions())) {
                return false;
            }
            if (!Objects.equals(_sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(_setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(_source, other.getSource())) {
                return false;
            }
            if (!Objects.equals(_symbolicPathName, other.getSymbolicPathName())) {
                return false;
            }
            if (!Objects.equals(_labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(_localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            if (!Objects.equals(_seStyleDesired, other.isSeStyleDesired())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PcepCreateP2pTunnelInputImpl otherImpl = (PcepCreateP2pTunnelInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepCreateP2pTunnelInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "PcepCreateP2pTunnelInput [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_bandwidth != null) {
                builder.append("_bandwidth=");
                builder.append(_bandwidth);
                builder.append(", ");
            }
            if (_classType != null) {
                builder.append("_classType=");
                builder.append(_classType);
                builder.append(", ");
            }
            if (_deadline != null) {
                builder.append("_deadline=");
                builder.append(_deadline);
                builder.append(", ");
            }
            if (_destination != null) {
                builder.append("_destination=");
                builder.append(_destination);
                builder.append(", ");
            }
            if (_excludeAny != null) {
                builder.append("_excludeAny=");
                builder.append(_excludeAny);
                builder.append(", ");
            }
            if (_explicitHops != null) {
                builder.append("_explicitHops=");
                builder.append(_explicitHops);
                builder.append(", ");
            }
            if (_holdPriority != null) {
                builder.append("_holdPriority=");
                builder.append(_holdPriority);
                builder.append(", ");
            }
            if (_id != null) {
                builder.append("_id=");
                builder.append(_id);
                builder.append(", ");
            }
            if (_includeAll != null) {
                builder.append("_includeAll=");
                builder.append(_includeAll);
                builder.append(", ");
            }
            if (_includeAny != null) {
                builder.append("_includeAny=");
                builder.append(_includeAny);
                builder.append(", ");
            }
            if (_networkTopologyRef != null) {
                builder.append("_networkTopologyRef=");
                builder.append(_networkTopologyRef);
                builder.append(", ");
            }
            if (_preconditions != null) {
                builder.append("_preconditions=");
                builder.append(_preconditions);
                builder.append(", ");
            }
            if (_sessionName != null) {
                builder.append("_sessionName=");
                builder.append(_sessionName);
                builder.append(", ");
            }
            if (_setupPriority != null) {
                builder.append("_setupPriority=");
                builder.append(_setupPriority);
                builder.append(", ");
            }
            if (_source != null) {
                builder.append("_source=");
                builder.append(_source);
                builder.append(", ");
            }
            if (_symbolicPathName != null) {
                builder.append("_symbolicPathName=");
                builder.append(_symbolicPathName);
                builder.append(", ");
            }
            if (_labelRecordingDesired != null) {
                builder.append("_labelRecordingDesired=");
                builder.append(_labelRecordingDesired);
                builder.append(", ");
            }
            if (_localProtectionDesired != null) {
                builder.append("_localProtectionDesired=");
                builder.append(_localProtectionDesired);
                builder.append(", ");
            }
            if (_seStyleDesired != null) {
                builder.append("_seStyleDesired=");
                builder.append(_seStyleDesired);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
