package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.DestroyTunnelInput;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep-programming</b>
 * <pre>
 * container input {
 *     leaf link-id {
 *         type link-id;
 *     }
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     uses destroy-tunnel-input;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>topology-tunnel-pcep-programming/pcep-destroy-tunnel/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelInputBuilder
 *
 */
public interface PcepDestroyTunnelInput
    extends
    DestroyTunnelInput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep:programming",
        "2013-10-30", "input").intern();


}

