package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep-programming</b>
 * <pre>
 * container input {
 *     leaf link-id {
 *         type link-id;
 *     }
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     list explicit-hops {
 *         key "order"
 *         leaf loose {
 *             type boolean;
 *         }
 *         leaf order {
 *             type uint32;
 *         }
 *         uses tunnel-p2p-path-hops;
 *     }
 *     leaf symbolic-path-name {
 *         type string;
 *     }
 *     leaf class-type {
 *         type class-type;
 *     }
 *     leaf bandwidth {
 *         type bandwidth;
 *     }
 *     leaf local-protection-desired {
 *         type local-protection-desired;
 *     }
 *     leaf label-recording-desired {
 *         type label-recording-desired;
 *     }
 *     leaf se-style-desired {
 *         type se-style-desired;
 *     }
 *     leaf session-name {
 *         type string;
 *     }
 *     leaf hold-priority {
 *         type hold-priority;
 *     }
 *     leaf setup-priority {
 *         type setup-priority;
 *     }
 *     leaf include-any {
 *         type attribute-filter;
 *     }
 *     leaf exclude-any {
 *         type attribute-filter;
 *     }
 *     leaf include-all {
 *         type attribute-filter;
 *     }
 *     uses base-tunnel-input;
 *     uses tunnel-pcep-link-cfg-attributes;
 *     uses tunnel-p2p-path-cfg-attributes;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>topology-tunnel-pcep-programming/pcep-update-tunnel/input</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInputBuilder
 *
 */
public interface PcepUpdateTunnelInput
    extends
    BaseTunnelInput,
    TunnelPcepLinkCfgAttributes,
    TunnelP2pPathCfgAttributes,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep:programming",
        "2013-10-30", "input").intern();


}

