package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1
 *
 */
public class Link1Builder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1> {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private AttributeFilter _excludeAny;
    private java.lang.Short _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private java.lang.String _sessionName;
    private java.lang.Short _setupPriority;
    private java.lang.String _symbolicPathName;
    private java.lang.Boolean _labelRecordingDesired;
    private java.lang.Boolean _localProtectionDesired;
    private java.lang.Boolean _seStyleDesired;


    public Link1Builder() {
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(Link1 base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._seStyleDesired = base.isSeStyleDesired();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters) {
            this._includeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority) {
            this._holdPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority)arg).getHoldPriority();
            this._setupPriority = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes) {
            this._localProtectionDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    public ClassType getClassType() {
        return _classType;
    }
    
    public AttributeFilter getExcludeAny() {
        return _excludeAny;
    }
    
    public java.lang.Short getHoldPriority() {
        return _holdPriority;
    }
    
    public AttributeFilter getIncludeAll() {
        return _includeAll;
    }
    
    public AttributeFilter getIncludeAny() {
        return _includeAny;
    }
    
    public java.lang.String getSessionName() {
        return _sessionName;
    }
    
    public java.lang.Short getSetupPriority() {
        return _setupPriority;
    }
    
    public java.lang.String getSymbolicPathName() {
        return _symbolicPathName;
    }
    
    public java.lang.Boolean isLabelRecordingDesired() {
        return _labelRecordingDesired;
    }
    
    public java.lang.Boolean isLocalProtectionDesired() {
        return _localProtectionDesired;
    }
    
    public java.lang.Boolean isSeStyleDesired() {
        return _seStyleDesired;
    }

     
    public Link1Builder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
     
    public Link1Builder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
     
    public Link1Builder setExcludeAny(final AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }
    
     
     private static void checkHoldPriorityRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
     }
    
    public Link1Builder setHoldPriority(final java.lang.Short value) {
    if (value != null) {
        checkHoldPriorityRange(value);
    }
        this._holdPriority = value;
        return this;
    }
    
     
    public Link1Builder setIncludeAll(final AttributeFilter value) {
        this._includeAll = value;
        return this;
    }
    
     
    public Link1Builder setIncludeAny(final AttributeFilter value) {
        this._includeAny = value;
        return this;
    }
    
     
    public Link1Builder setSessionName(final java.lang.String value) {
        this._sessionName = value;
        return this;
    }
    
     
     private static void checkSetupPriorityRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
     }
    
    public Link1Builder setSetupPriority(final java.lang.Short value) {
    if (value != null) {
        checkSetupPriorityRange(value);
    }
        this._setupPriority = value;
        return this;
    }
    
     
    public Link1Builder setSymbolicPathName(final java.lang.String value) {
        this._symbolicPathName = value;
        return this;
    }
    
     
    public Link1Builder setLabelRecordingDesired(final java.lang.Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }
    
     
    public Link1Builder setLocalProtectionDesired(final java.lang.Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }
    
     
    public Link1Builder setSeStyleDesired(final java.lang.Boolean value) {
        this._seStyleDesired = value;
        return this;
    }

    @Override
    public Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl implements Link1 {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1.class;
        }

        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final AttributeFilter _excludeAny;
        private final java.lang.Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final java.lang.String _sessionName;
        private final java.lang.Short _setupPriority;
        private final java.lang.String _symbolicPathName;
        private final java.lang.Boolean _labelRecordingDesired;
        private final java.lang.Boolean _localProtectionDesired;
        private final java.lang.Boolean _seStyleDesired;


        private Link1Impl(Link1Builder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._seStyleDesired = base.isSeStyleDesired();
        }

        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public AttributeFilter getExcludeAny() {
            return _excludeAny;
        }
        
        @Override
        public java.lang.Short getHoldPriority() {
            return _holdPriority;
        }
        
        @Override
        public AttributeFilter getIncludeAll() {
            return _includeAll;
        }
        
        @Override
        public AttributeFilter getIncludeAny() {
            return _includeAny;
        }
        
        @Override
        public java.lang.String getSessionName() {
            return _sessionName;
        }
        
        @Override
        public java.lang.Short getSetupPriority() {
            return _setupPriority;
        }
        
        @Override
        public java.lang.String getSymbolicPathName() {
            return _symbolicPathName;
        }
        
        @Override
        public java.lang.Boolean isLabelRecordingDesired() {
            return _labelRecordingDesired;
        }
        
        @Override
        public java.lang.Boolean isLocalProtectionDesired() {
            return _localProtectionDesired;
        }
        
        @Override
        public java.lang.Boolean isSeStyleDesired() {
            return _seStyleDesired;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_bandwidth);
            result = prime * result + Objects.hashCode(_classType);
            result = prime * result + Objects.hashCode(_excludeAny);
            result = prime * result + Objects.hashCode(_holdPriority);
            result = prime * result + Objects.hashCode(_includeAll);
            result = prime * result + Objects.hashCode(_includeAny);
            result = prime * result + Objects.hashCode(_sessionName);
            result = prime * result + Objects.hashCode(_setupPriority);
            result = prime * result + Objects.hashCode(_symbolicPathName);
            result = prime * result + Objects.hashCode(_labelRecordingDesired);
            result = prime * result + Objects.hashCode(_localProtectionDesired);
            result = prime * result + Objects.hashCode(_seStyleDesired);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1)obj;
            if (!Objects.equals(_bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(_classType, other.getClassType())) {
                return false;
            }
            if (!Objects.equals(_excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(_holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(_includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(_includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(_sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(_setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(_symbolicPathName, other.getSymbolicPathName())) {
                return false;
            }
            if (!Objects.equals(_labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(_localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            if (!Objects.equals(_seStyleDesired, other.isSeStyleDesired())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "Link1 [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_bandwidth != null) {
                builder.append("_bandwidth=");
                builder.append(_bandwidth);
                builder.append(", ");
            }
            if (_classType != null) {
                builder.append("_classType=");
                builder.append(_classType);
                builder.append(", ");
            }
            if (_excludeAny != null) {
                builder.append("_excludeAny=");
                builder.append(_excludeAny);
                builder.append(", ");
            }
            if (_holdPriority != null) {
                builder.append("_holdPriority=");
                builder.append(_holdPriority);
                builder.append(", ");
            }
            if (_includeAll != null) {
                builder.append("_includeAll=");
                builder.append(_includeAll);
                builder.append(", ");
            }
            if (_includeAny != null) {
                builder.append("_includeAny=");
                builder.append(_includeAny);
                builder.append(", ");
            }
            if (_sessionName != null) {
                builder.append("_sessionName=");
                builder.append(_sessionName);
                builder.append(", ");
            }
            if (_setupPriority != null) {
                builder.append("_setupPriority=");
                builder.append(_setupPriority);
                builder.append(", ");
            }
            if (_symbolicPathName != null) {
                builder.append("_symbolicPathName=");
                builder.append(_symbolicPathName);
                builder.append(", ");
            }
            if (_labelRecordingDesired != null) {
                builder.append("_labelRecordingDesired=");
                builder.append(_labelRecordingDesired);
                builder.append(", ");
            }
            if (_localProtectionDesired != null) {
                builder.append("_localProtectionDesired=");
                builder.append(_localProtectionDesired);
                builder.append(", ");
            }
            if (_seStyleDesired != null) {
                builder.append("_seStyleDesired=");
                builder.append(_seStyleDesired);
            }
            return builder.append(']').toString();
        }
    }

}
