package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1
 *
 */
public class ReportedHops1Builder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1> {

    private SubobjectType _subobjectType;
    private java.lang.Boolean _protectionAvailable;
    private java.lang.Boolean _protectionInUse;


    public ReportedHops1Builder() {
    }
    public ReportedHops1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects arg) {
        this._protectionAvailable = arg.isProtectionAvailable();
        this._protectionInUse = arg.isProtectionInUse();
        this._subobjectType = arg.getSubobjectType();
    }

    public ReportedHops1Builder(ReportedHops1 base) {
        this._subobjectType = base.getSubobjectType();
        this._protectionAvailable = base.isProtectionAvailable();
        this._protectionInUse = base.isProtectionInUse();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects) {
            this._protectionAvailable = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects)arg).isProtectionAvailable();
            this._protectionInUse = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects)arg).isProtectionInUse();
            this._subobjectType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects)arg).getSubobjectType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects] \n" +
              "but was: " + arg
            );
        }
    }

    public SubobjectType getSubobjectType() {
        return _subobjectType;
    }
    
    public java.lang.Boolean isProtectionAvailable() {
        return _protectionAvailable;
    }
    
    public java.lang.Boolean isProtectionInUse() {
        return _protectionInUse;
    }

     
    public ReportedHops1Builder setSubobjectType(final SubobjectType value) {
        this._subobjectType = value;
        return this;
    }
    
     
    public ReportedHops1Builder setProtectionAvailable(final java.lang.Boolean value) {
        this._protectionAvailable = value;
        return this;
    }
    
     
    public ReportedHops1Builder setProtectionInUse(final java.lang.Boolean value) {
        this._protectionInUse = value;
        return this;
    }

    @Override
    public ReportedHops1 build() {
        return new ReportedHops1Impl(this);
    }

    private static final class ReportedHops1Impl implements ReportedHops1 {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1.class;
        }

        private final SubobjectType _subobjectType;
        private final java.lang.Boolean _protectionAvailable;
        private final java.lang.Boolean _protectionInUse;


        private ReportedHops1Impl(ReportedHops1Builder base) {
            this._subobjectType = base.getSubobjectType();
            this._protectionAvailable = base.isProtectionAvailable();
            this._protectionInUse = base.isProtectionInUse();
        }

        @Override
        public SubobjectType getSubobjectType() {
            return _subobjectType;
        }
        
        @Override
        public java.lang.Boolean isProtectionAvailable() {
            return _protectionAvailable;
        }
        
        @Override
        public java.lang.Boolean isProtectionInUse() {
            return _protectionInUse;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_subobjectType);
            result = prime * result + Objects.hashCode(_protectionAvailable);
            result = prime * result + Objects.hashCode(_protectionInUse);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.ReportedHops1)obj;
            if (!Objects.equals(_subobjectType, other.getSubobjectType())) {
                return false;
            }
            if (!Objects.equals(_protectionAvailable, other.isProtectionAvailable())) {
                return false;
            }
            if (!Objects.equals(_protectionInUse, other.isProtectionInUse())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "ReportedHops1 [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_subobjectType != null) {
                builder.append("_subobjectType=");
                builder.append(_subobjectType);
                builder.append(", ");
            }
            if (_protectionAvailable != null) {
                builder.append("_protectionAvailable=");
                builder.append(_protectionAvailable);
                builder.append(", ");
            }
            if (_protectionInUse != null) {
                builder.append("_protectionInUse=");
                builder.append(_protectionInUse);
            }
            return builder.append(']').toString();
        }
    }

}
