package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.type.PcepTunnel;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1
 *
 */
public class TunnelTypes1Builder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1> {

    private PcepTunnel _pcepTunnel;


    public TunnelTypes1Builder() {
    }
    public TunnelTypes1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepType arg) {
        this._pcepTunnel = arg.getPcepTunnel();
    }

    public TunnelTypes1Builder(TunnelTypes1 base) {
        this._pcepTunnel = base.getPcepTunnel();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepType</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepType) {
            this._pcepTunnel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepType)arg).getPcepTunnel();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepType] \n" +
              "but was: " + arg
            );
        }
    }

    public PcepTunnel getPcepTunnel() {
        return _pcepTunnel;
    }

     
    public TunnelTypes1Builder setPcepTunnel(final PcepTunnel value) {
        this._pcepTunnel = value;
        return this;
    }

    @Override
    public TunnelTypes1 build() {
        return new TunnelTypes1Impl(this);
    }

    private static final class TunnelTypes1Impl implements TunnelTypes1 {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1.class;
        }

        private final PcepTunnel _pcepTunnel;


        private TunnelTypes1Impl(TunnelTypes1Builder base) {
            this._pcepTunnel = base.getPcepTunnel();
        }

        @Override
        public PcepTunnel getPcepTunnel() {
            return _pcepTunnel;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_pcepTunnel);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelTypes1)obj;
            if (!Objects.equals(_pcepTunnel, other.getPcepTunnel())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "TunnelTypes1 [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_pcepTunnel != null) {
                builder.append("_pcepTunnel=");
                builder.append(_pcepTunnel);
            }
            return builder.append(']').toString();
        }
    }

}
