package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.DestroyTunnelOutput;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep-programming</b>
 * <pre>
 * container output {
 *     choice result {
 *         case failure-case {
 *             container failure {
 *                 leaf type {
 *                     type identityref;
 *                 }
 *                 leaf-list failed-preconditions {
 *                     type instruction-id;
 *                 }
 *             }
 *         }
 *     }
 *     uses destroy-tunnel-output;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>topology-tunnel-pcep-programming/pcep-destroy-tunnel/output</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelOutputBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelOutputBuilder
 *
 */
public interface PcepDestroyTunnelOutput
    extends
    DestroyTunnelOutput,
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepDestroyTunnelOutput>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep:programming",
        "2013-10-30", "output").intern();


}

