package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>topology-tunnel-pcep-programming</b>
 * <pre>
 * rpc pcep-create-p2p-tunnel {
 *     input {
 *         container destination {
 *             leaf node {
 *                 type node-ref;
 *             }
 *             leaf tp {
 *                 type tp-ref;
 *             }
 *             uses tp-reference;
 *         }
 *         container source {
 *             leaf node {
 *                 type node-ref;
 *             }
 *             leaf tp {
 *                 type tp-ref;
 *             }
 *             uses tp-reference;
 *         }
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *         leaf network-topology-ref {
 *             type network-topology-ref;
 *         }
 *         list explicit-hops {
 *             key "order";
 *             leaf loose {
 *                 type boolean;
 *             }
 *             leaf order {
 *                 type uint32;
 *             }
 *             uses tunnel-p2p-path-hops;
 *         }
 *         leaf symbolic-path-name {
 *             type string;
 *         }
 *         leaf class-type {
 *             type class-type;
 *         }
 *         leaf bandwidth {
 *             type bandwidth;
 *         }
 *         leaf local-protection-desired {
 *             type local-protection-desired;
 *         }
 *         leaf label-recording-desired {
 *             type label-recording-desired;
 *         }
 *         leaf se-style-desired {
 *             type se-style-desired;
 *         }
 *         leaf session-name {
 *             type string;
 *         }
 *         leaf hold-priority {
 *             type hold-priority;
 *         }
 *         leaf setup-priority {
 *             type setup-priority;
 *         }
 *         leaf include-any {
 *             type attribute-filter;
 *         }
 *         leaf exclude-any {
 *             type attribute-filter;
 *         }
 *         leaf include-all {
 *             type attribute-filter;
 *         }
 *     }
 *     
 *     output {
 *         leaf link-id {
 *             type link-id;
 *         }
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 * }
 * rpc pcep-update-tunnel {
 *     input {
 *         leaf link-id {
 *             type link-id;
 *         }
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *         leaf network-topology-ref {
 *             type network-topology-ref;
 *         }
 *         list explicit-hops {
 *             key "order";
 *             leaf loose {
 *                 type boolean;
 *             }
 *             leaf order {
 *                 type uint32;
 *             }
 *             uses tunnel-p2p-path-hops;
 *         }
 *         leaf symbolic-path-name {
 *             type string;
 *         }
 *         leaf class-type {
 *             type class-type;
 *         }
 *         leaf bandwidth {
 *             type bandwidth;
 *         }
 *         leaf local-protection-desired {
 *             type local-protection-desired;
 *         }
 *         leaf label-recording-desired {
 *             type label-recording-desired;
 *         }
 *         leaf se-style-desired {
 *             type se-style-desired;
 *         }
 *         leaf session-name {
 *             type string;
 *         }
 *         leaf hold-priority {
 *             type hold-priority;
 *         }
 *         leaf setup-priority {
 *             type setup-priority;
 *         }
 *         leaf include-any {
 *             type attribute-filter;
 *         }
 *         leaf exclude-any {
 *             type attribute-filter;
 *         }
 *         leaf include-all {
 *             type attribute-filter;
 *         }
 *     }
 *     
 *     output {
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 * }
 * rpc pcep-destroy-tunnel {
 *     input {
 *         leaf link-id {
 *             type link-id;
 *         }
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *         leaf network-topology-ref {
 *             type network-topology-ref;
 *         }
 *     }
 *     
 *     output {
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface TopologyTunnelPcepProgrammingService
    extends
    RpcService
{




    Future<RpcResult<PcepCreateP2pTunnelOutput>> pcepCreateP2pTunnel(PcepCreateP2pTunnelInput input);
    
    Future<RpcResult<PcepUpdateTunnelOutput>> pcepUpdateTunnel(PcepUpdateTunnelInput input);
    
    Future<RpcResult<PcepDestroyTunnelOutput>> pcepDestroyTunnel(PcepDestroyTunnelInput input);

}

