package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep</b>
 * <pre>
 * grouping tunnel-pcep-link-cfg-attributes {
 *     leaf symbolic-path-name {
 *         type string;
 *     }
 *     leaf class-type {
 *         type class-type;
 *     }
 *     leaf bandwidth {
 *         type bandwidth;
 *     }
 *     leaf local-protection-desired {
 *         type local-protection-desired;
 *     }
 *     leaf label-recording-desired {
 *         type label-recording-desired;
 *     }
 *     leaf se-style-desired {
 *         type se-style-desired;
 *     }
 *     leaf session-name {
 *         type string;
 *     }
 *     leaf hold-priority {
 *         type hold-priority;
 *     }
 *     leaf setup-priority {
 *         type setup-priority;
 *     }
 *     leaf include-any {
 *         type attribute-filter;
 *     }
 *     leaf exclude-any {
 *         type attribute-filter;
 *     }
 *     leaf include-all {
 *         type attribute-filter;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>topology-tunnel-pcep/tunnel-pcep-link-cfg-attributes</i>
 *
 */
public interface TunnelPcepLinkCfgAttributes
    extends
    DataObject,
    TunnelAttributes
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep",
        "2013-08-20", "tunnel-pcep-link-cfg-attributes").intern();

    /**
     * @return <code>java.lang.String</code> <code>symbolicPathName</code>, or <code>null</code> if not present
     */
    java.lang.String getSymbolicPathName();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType</code> <code>classType</code>, or <code>null</code> if not present
     */
    ClassType getClassType();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth</code> <code>bandwidth</code>, or <code>null</code> if not present
     */
    Bandwidth getBandwidth();

}

