package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.supporting.node.attributes;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepSupportingNodeAttributes;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>topology-tunnel-pcep</b>
 * <pre>
 * container path-computation-client {
 *     leaf controlling {
 *         type controlling;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>topology-tunnel-pcep/tunnel-pcep-supporting-node-attributes/path-computation-client</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.supporting.node.attributes.PathComputationClientBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.supporting.node.attributes.PathComputationClientBuilder
 *
 */
public interface PathComputationClient
    extends
    ChildOf<TunnelPcepSupportingNodeAttributes>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.supporting.node.attributes.PathComputationClient>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:tunnel:pcep",
        "2013-08-20", "path-computation-client").intern();

    /**
     * @return <code>java.lang.Boolean</code> <code>controlling</code>, or <code>null</code> if not present
     */
    java.lang.Boolean isControlling();

}

