/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum InstructionStatus implements Enumeration
{
    Queued(0, "queued"),
    Scheduled(1, "scheduled"),
    Executing(2, "executing"),
    Cancelled(3, "cancelled"),
    Failed(4, "failed"),
    Successful(5, "successful"),
    Unknown(6, "unknown");

    private static final Map<String, InstructionStatus> NAME_MAP;
    private static final Map<Integer, InstructionStatus> VALUE_MAP;
    private final String name;
    private final int value;

    private InstructionStatus(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<InstructionStatus> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static InstructionStatus forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (InstructionStatus enumItem : InstructionStatus.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

