/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class InstructionBuilder
implements Builder<Instruction> {
    private Nanotime _deadline;
    private InstructionId _id;
    private InstructionStatus _status;
    private InstructionKey key;
    Map<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> augmentation = Collections.emptyMap();

    public InstructionBuilder() {
    }

    public InstructionBuilder(Instruction base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(aug);
        }
        this.key = base.key();
        this._id = base.getId();
        this._deadline = base.getDeadline();
        this._status = base.getStatus();
    }

    public InstructionKey key() {
        return this.key;
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public InstructionId getId() {
        return this._id;
    }

    public InstructionStatus getStatus() {
        return this._status;
    }

    public <E$$ extends Augmentation<Instruction>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public InstructionBuilder withKey(InstructionKey key) {
        this.key = key;
        return this;
    }

    public InstructionBuilder setDeadline(Nanotime value) {
        this._deadline = value;
        return this;
    }

    public InstructionBuilder setId(InstructionId value) {
        this._id = value;
        return this;
    }

    public InstructionBuilder setStatus(InstructionStatus value) {
        this._status = value;
        return this;
    }

    public InstructionBuilder addAugmentation(Augmentation<Instruction> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InstructionBuilder removeAugmentation(Class<? extends Augmentation<Instruction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Instruction build() {
        return new InstructionImpl(this);
    }

    private static final class InstructionImpl
    extends AbstractAugmentable<Instruction>
    implements Instruction {
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final InstructionStatus _status;
        private final InstructionKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        InstructionImpl(InstructionBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new InstructionKey(base.getId());
            this._id = this.key.getId();
            this._deadline = base.getDeadline();
            this._status = base.getStatus();
        }

        @Override
        public InstructionKey key() {
            return this.key;
        }

        @Override
        public Nanotime getDeadline() {
            return this._deadline;
        }

        @Override
        public InstructionId getId() {
            return this._id;
        }

        @Override
        public InstructionStatus getStatus() {
            return this._status;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Instruction.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Instruction.bindingEquals(this, obj);
        }

        public String toString() {
            return Instruction.bindingToString(this);
        }
    }
}

