/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueueKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.Instruction;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstructionsQueueBuilder
implements Builder<InstructionsQueue> {
    private List<Instruction> _instruction;
    private String _instructionQueueId;
    private InstructionsQueueKey _key;
    Map<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>> augmentation = Collections.emptyMap();

    public InstructionsQueueBuilder() {
    }

    public InstructionsQueueBuilder(InstructionQueue arg) {
        this._instructionQueueId = arg.getInstructionQueueId();
        this._instruction = arg.getInstruction();
    }

    public InstructionsQueueBuilder(InstructionsQueue base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InstructionsQueueKey(base.getInstructionQueueId());
            this._instructionQueueId = base.getInstructionQueueId();
        } else {
            this._key = base.getKey();
            this._instructionQueueId = this._key.getInstructionQueueId();
        }
        this._instruction = base.getInstruction();
        if (base instanceof InstructionsQueueImpl) {
            InstructionsQueueImpl impl = (InstructionsQueueImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof InstructionQueue) {
            this._instructionQueueId = ((InstructionQueue)arg).getInstructionQueueId();
            this._instruction = ((InstructionQueue)arg).getInstruction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionQueue] \nbut was: " + arg);
        }
    }

    public List<Instruction> getInstruction() {
        return this._instruction;
    }

    public String getInstructionQueueId() {
        return this._instructionQueueId;
    }

    public InstructionsQueueKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<InstructionsQueue>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstructionsQueueBuilder setInstruction(List<Instruction> value) {
        this._instruction = value;
        return this;
    }

    public InstructionsQueueBuilder setInstructionQueueId(String value) {
        this._instructionQueueId = value;
        return this;
    }

    public InstructionsQueueBuilder setKey(InstructionsQueueKey value) {
        this._key = value;
        return this;
    }

    public InstructionsQueueBuilder addAugmentation(Class<? extends Augmentation<InstructionsQueue>> augmentationType, Augmentation<InstructionsQueue> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InstructionsQueueBuilder removeAugmentation(Class<? extends Augmentation<InstructionsQueue>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public InstructionsQueue build() {
        return new InstructionsQueueImpl(this);
    }

    private static final class InstructionsQueueImpl
    implements InstructionsQueue {
        private final List<Instruction> _instruction;
        private final String _instructionQueueId;
        private final InstructionsQueueKey _key;
        private Map<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<InstructionsQueue> getImplementedInterface() {
            return InstructionsQueue.class;
        }

        private InstructionsQueueImpl(InstructionsQueueBuilder base) {
            if (base.getKey() == null) {
                this._key = new InstructionsQueueKey(base.getInstructionQueueId());
                this._instructionQueueId = base.getInstructionQueueId();
            } else {
                this._key = base.getKey();
                this._instructionQueueId = this._key.getInstructionQueueId();
            }
            this._instruction = base.getInstruction();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>>(base.augmentation);
                }
            }
        }

        @Override
        public List<Instruction> getInstruction() {
            return this._instruction;
        }

        @Override
        public String getInstructionQueueId() {
            return this._instructionQueueId;
        }

        @Override
        public InstructionsQueueKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<InstructionsQueue>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._instruction);
            result = 31 * result + Objects.hashCode(this._instructionQueueId);
            result = 31 * result + Objects.hashCode(this._key);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!InstructionsQueue.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            InstructionsQueue other = (InstructionsQueue)obj;
            if (!Objects.equals(this._instruction, other.getInstruction())) {
                return false;
            }
            if (!Objects.equals(this._instructionQueueId, other.getInstructionQueueId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstructionsQueueImpl otherImpl = (InstructionsQueueImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<InstructionsQueue>>, Augmentation<InstructionsQueue>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "InstructionsQueue [";
            StringBuilder builder = new StringBuilder(name);
            if (this._instruction != null) {
                builder.append("_instruction=");
                builder.append(this._instruction);
                builder.append(", ");
            }
            if (this._instructionQueueId != null) {
                builder.append("_instructionQueueId=");
                builder.append(this._instructionQueueId);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

