/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstructionBuilder
implements Builder<Instruction> {
    private Nanotime _deadline;
    private InstructionId _id;
    private InstructionKey _key;
    private InstructionStatus _status;
    Map<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> augmentation = Collections.emptyMap();

    public InstructionBuilder() {
    }

    public InstructionBuilder(Instruction base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new InstructionKey(base.getId());
            this._id = base.getId();
        } else {
            this._key = base.getKey();
            this._id = this._key.getId();
        }
        this._deadline = base.getDeadline();
        this._status = base.getStatus();
        if (base instanceof InstructionImpl) {
            InstructionImpl impl = (InstructionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(casted.augmentations());
        }
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public InstructionId getId() {
        return this._id;
    }

    public InstructionKey getKey() {
        return this._key;
    }

    public InstructionStatus getStatus() {
        return this._status;
    }

    public <E extends Augmentation<Instruction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstructionBuilder setDeadline(Nanotime value) {
        this._deadline = value;
        return this;
    }

    public InstructionBuilder setId(InstructionId value) {
        this._id = value;
        return this;
    }

    public InstructionBuilder setKey(InstructionKey value) {
        this._key = value;
        return this;
    }

    public InstructionBuilder setStatus(InstructionStatus value) {
        this._status = value;
        return this;
    }

    public InstructionBuilder addAugmentation(Class<? extends Augmentation<Instruction>> augmentationType, Augmentation<Instruction> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public InstructionBuilder removeAugmentation(Class<? extends Augmentation<Instruction>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Instruction build() {
        return new InstructionImpl(this);
    }

    private static final class InstructionImpl
    implements Instruction {
        private final Nanotime _deadline;
        private final InstructionId _id;
        private final InstructionKey _key;
        private final InstructionStatus _status;
        private Map<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Instruction> getImplementedInterface() {
            return Instruction.class;
        }

        private InstructionImpl(InstructionBuilder base) {
            if (base.getKey() == null) {
                this._key = new InstructionKey(base.getId());
                this._id = base.getId();
            } else {
                this._key = base.getKey();
                this._id = this._key.getId();
            }
            this._deadline = base.getDeadline();
            this._status = base.getStatus();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>>(base.augmentation);
                }
            }
        }

        @Override
        public Nanotime getDeadline() {
            return this._deadline;
        }

        @Override
        public InstructionId getId() {
            return this._id;
        }

        @Override
        public InstructionKey getKey() {
            return this._key;
        }

        @Override
        public InstructionStatus getStatus() {
            return this._status;
        }

        public <E extends Augmentation<Instruction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadline);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode((Object)this._status);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Instruction.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Instruction other = (Instruction)obj;
            if (!Objects.equals(this._deadline, other.getDeadline())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals((Object)this._status, (Object)other.getStatus())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                InstructionImpl otherImpl = (InstructionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Instruction>>, Augmentation<Instruction>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Instruction [";
            StringBuilder builder = new StringBuilder(name);
            if (this._deadline != null) {
                builder.append("_deadline=");
                builder.append(this._deadline);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._status != null) {
                builder.append("_status=");
                builder.append((Object)this._status);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

