package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The instruction was submitted after its deadline has passed, or one of its 
 * dependencies resolved as non-sunccessful.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * identity dead-on-arrival {
 *     base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *     description
 *         "The instruction was submitted after its deadline has
 *                     passed, or one of its dependencies resolved as
 *                     non-sunccessful.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/dead-on-arrival</i>
 *
 */
public abstract class DeadOnArrival extends SubmitFailure
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "dead-on-arrival").intern();


    public DeadOnArrival() {
    
    
    }
    






}

