package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Instruction ID clashes with an instruction with an already-queued instruction. 
 * Assign a new identifier or wait for the enqueued instruction to complete.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * identity duplicate-instruction-id {
 *     base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *     description
 *         "Instruction ID clashes with an instruction with an
 *                     already-queued instruction. Assign a new identifier
 *                     or wait for the enqueued instruction to complete.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/duplicate-instruction-id</i>
 *
 */
public abstract class DuplicateInstructionId extends SubmitFailure
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "duplicate-instruction-id").intern();


    public DuplicateInstructionId() {
    
    
    }
    






}

