package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import java.io.Serializable;
import java.beans.ConstructorProperties;
import com.google.common.base.Preconditions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;

/**
 * Instruction identifier. It is assigned by the entity
 *             generating the instruction and is required to be unique
 *             during the lifetime of the instruction.
 *
 */
public class InstructionId extends Uri
 implements Serializable {
    private static final long serialVersionUID = 8262312312067274609L;


    @ConstructorProperties("value")
    public InstructionId(java.lang.String _value) {
        super(_value);
    
    
        Preconditions.checkNotNull(_value, "Supplied value may not be null");
    
    
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public InstructionId(InstructionId source) {
        super(source);
    }
    /**
     * Creates a new instance from Uri
     *
     * @param source Source object
     */
    public InstructionId(Uri source) {
            super(source);
    }

    public static InstructionId getDefaultInstance(String defaultValue) {
        return new InstructionId(defaultValue);
    }





}

