package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.Instruction;

/**
 * The bare minimum run-time information which should be exposed by an 
 * implementation of the instruction scheduler defined in this model
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * grouping instruction-queue {
 *     leaf instruction-queue-id {
 *         type string;
 *     }
 *     list instruction {
 *         key "id"
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf status {
 *             type instruction-status;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/instruction-queue</i>
 *
 */
public interface InstructionQueue
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "instruction-queue").intern();

    /**
     * @return <code>java.lang.String</code> <code>instructionQueueId</code>, or <code>null</code> if not present
     */
    java.lang.String getInstructionQueueId();
    
    /**
     * List of all instructions known to the scheduler.
     *
     *
     *
     * @return <code>java.util.List</code> <code>instruction</code>, or <code>null</code> if not present
     */
    List<Instruction> getInstruction();

}

