package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;

public enum InstructionStatus {
    /**
     * Its immediate prerequisite intructions have not been resolved. The instruction 
     * can be cancelled. If any of its prerequisites moves to Unknown, Failed or 
     * Cancelled state, the instruction itself moves into Cancelled state. Once all of 
     * the dependencies move into Successful state, this instruction moves into 
     * Scheduled state. If this instruction's deadline passes, it transitions into 
     * Cancelled state.
     *
     */
    Queued(0, "queued"),
    
    /**
     * All of instruction's prerequisites have been successful and this instruction is 
     * ready to be executed, but the resources needed for its execution are not ready. 
     * The instruction can be Cancelled. If this instruction's deadline passes, it 
     * transitions into Failed state.
     *
     */
    Scheduled(1, "scheduled"),
    
    /**
     * The instruction is being executed. It cannot be Cancelled on request. If the 
     * execution does not complete within the specified deadline, this instruction 
     * moves into Unknown state. If the instruction's execution completes within the 
     * deadline, it moves into Successful, Failed or Cancelled state, based on the 
     * effects it has had on state.
     *
     */
    Executing(2, "executing"),
    
    /**
     * The instruction has never executed, or has been executing but all its effects 
     * have been rolled back. System state is such as if the instruction never 
     * executed.
     *
     */
    Cancelled(3, "cancelled"),
    
    /**
     * The instruciton has failed to execute completely, but some of its effects may 
     * have been recorded in the state. A full state resynchronization is required to 
     * recover from this failure, and even then an operator intervention may be 
     * required (if, for example the effect is not representable in exposed 
     * abstractions).
     *
     */
    Failed(4, "failed"),
    
    /**
     * The instruction has executed competely and its effects have been recorded in 
     * state.
     *
     */
    Successful(5, "successful"),
    
    /**
     * The instruction has failed to execute within the deadline allocated to it. It's 
     * effects on the state are unknown at this point, but can be assumed to either 
     * atomically happen or not-happen. This state is transient and the instruction 
     * will eventually (at some indeterminate point in the future) enter either 
     * Successful, Failed or Cancelled state.
     *
     */
    Unknown(6, "unknown")
    ;


    java.lang.String name;
    int value;
    private static final java.util.Map<java.lang.Integer, InstructionStatus> VALUE_MAP;

    static {
        final com.google.common.collect.ImmutableMap.Builder<java.lang.Integer, InstructionStatus> b = com.google.common.collect.ImmutableMap.builder();
        for (InstructionStatus enumItem : InstructionStatus.values())
        {
            b.put(enumItem.value, enumItem);
        }

        VALUE_MAP = b.build();
    }

    private InstructionStatus(int value, java.lang.String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * Returns the name of the enumeration item as it is specified in the input yang.
     *
     * @return the name of the enumeration item as it is specified in the input yang
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * @return integer value
     */
    public int getIntValue() {
        return value;
    }

    /**
     * @param valueArg
     * @return corresponding InstructionStatus item
     */
    public static InstructionStatus forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }
}
