package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.status.changed.Details;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Notification;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * notification instruction-status-changed {
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf status {
 *         type instruction-status;
 *     }
 *     container details {
 *         leaf-list unmet-dependencies {
 *             type instruction-id;
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/instruction-status-changed</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatusChangedBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatusChangedBuilder
 *
 */
public interface InstructionStatusChanged
    extends
    DataObject,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatusChanged>,
    Notification
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "instruction-status-changed").intern();

    /**
     * Instruction identifier.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId</code> <code>id</code>, or <code>null</code> if not present
     */
    InstructionId getId();
    
    /**
     * New status of the instruction.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus</code> <code>status</code>, or <code>null</code> if not present
     */
    InstructionStatus getStatus();
    
    /**
     * More details about the instruction state.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.status.changed.Details</code> <code>details</code>, or <code>null</code> if not present
     */
    Details getDetails();

}

