package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * list instructions-queue {
 *     key "instruction-queue-id"
 *     leaf instruction-queue-id {
 *         type string;
 *     }
 *     list instruction {
 *         key "id"
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf status {
 *             type instruction-status;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *     }
 *     uses instruction-queue;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/instructions-queue</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueueBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueueBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueueKey
 *
 */
public interface InstructionsQueue
    extends
    ChildOf<ProgrammingData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueue>,
    InstructionQueue,
    Identifiable<InstructionsQueueKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "instructions-queue").intern();

    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionsQueueKey</code> <code>key</code>, or <code>null</code> if not present
     */
    InstructionsQueueKey getKey();

}

