package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import java.util.List;

/**
 * This module contains the basic programming model. From the architecture 
 * perspective, the programming model is used to drive the state of the controller 
 * and, by extension, its underlying network from one state to another, usually 
 * through some interim states. The core concept of this model is that of an 
 * instruction. An instruction is always an atomic, undivisible amount of work, 
 * resulting in a well-defined state transition. More complex state transitions 
 * always broken up to a set of such instructions. As a general rule, instructions 
 * should be designed such that their implementations can guarantee them either 
 * happening completely or not happening at all. Instruction scheduling is 
 * by explicit dependencies, where an instruction may only be a candidate for 
 * execution if all of its dependencies have completed successfully. If there are 
 * multiple candidate instructions, the scheduler is free to decide on the order 
 * execution, it may even execute them in parallel. If two instructions become 
 * candidates and cannot be executed in parallel, the scheduler should execute 
 * in the order in which they have been submitted. The programming model does not 
 * rely on rollback capability being present in the network. Instead it recognizes 
 * that this failure results in a new state, which needs to be picked up by the 
 * entity driving the change and a new set of state transitions needs to be 
 * devised. Technology-specific modules should rely on this assumption and should 
 * not attempt complex recovery schemes, which could result in more indeterminism 
 * being introduced in the state. The final assumption of the model is that each 
 * instruction has a specific deadline by which it needs to complete. The 
 * is that the entity driving the state has to make some progress and not be stuck 
 * indefinitely on one transition. Furthermore the model assumes the realization 
 * that there is a failure in making progress in the scheduler, such that the 
 * instruction stream can be predictably cut without introducing new race windows 
 * in the recovery path. A summary of the model is the following: the scheduler 
 * operates on a directed acyclic graph of instructions which places limits on 
 * which interim states may be visited while the system transitions from a state 
 * measured at a point in time into the intended state. The graph may be expanded 
 * to include new nodes, allowing for futher submissions in a manner consistent 
 * with optimistic prediction of future state. Copyright (c)2013 Cisco Systems, 
 * Inc. All rights reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0 which accompanies 
 * this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * module programming {
 *     yang-version 1;
 *     namespace "urn:opendaylight:params:xml:ns:yang:programming";
 *     prefix "pgm";
 *
 *     import ietf-inet-types { prefix "inet"; }
 *     revision 2015-07-20 {
 *         description "This module contains the basic programming model. From the architecture 
 *                     perspective, the programming model is used to drive the state of the controller 
 *                     and, by extension, its underlying network from one state to another, usually 
 *                     through some interim states. The core concept of this model is that of an 
 *                     instruction. An instruction is always an atomic, undivisible amount of work, 
 *                     resulting in a well-defined state transition. More complex state transitions 
 *                     always broken up to a set of such instructions. As a general rule, instructions 
 *                     should be designed such that their implementations can guarantee them either 
 *                     happening completely or not happening at all. Instruction scheduling is 
 *                     by explicit dependencies, where an instruction may only be a candidate for 
 *                     execution if all of its dependencies have completed successfully. If there are 
 *                     multiple candidate instructions, the scheduler is free to decide on the order 
 *                     execution, it may even execute them in parallel. If two instructions become 
 *                     candidates and cannot be executed in parallel, the scheduler should execute 
 *                     in the order in which they have been submitted. The programming model does not 
 *                     rely on rollback capability being present in the network. Instead it recognizes 
 *                     that this failure results in a new state, which needs to be picked up by the 
 *                     entity driving the change and a new set of state transitions needs to be 
 *                     devised. Technology-specific modules should rely on this assumption and should 
 *                     not attempt complex recovery schemes, which could result in more indeterminism 
 *                     being introduced in the state. The final assumption of the model is that each 
 *                     instruction has a specific deadline by which it needs to complete. The 
 *                     is that the entity driving the state has to make some progress and not be stuck 
 *                     indefinitely on one transition. Furthermore the model assumes the realization 
 *                     that there is a failure in making progress in the scheduler, such that the 
 *                     instruction stream can be predictably cut without introducing new race windows 
 *                     in the recovery path. A summary of the model is the following: the scheduler 
 *                     operates on a directed acyclic graph of instructions which places limits on 
 *                     which interim states may be visited while the system transitions from a state 
 *                     measured at a point in time into the intended state. The graph may be expanded 
 *                     to include new nodes, allowing for futher submissions in a manner consistent 
 *                     with optimistic prediction of future state. Copyright (c)2013 Cisco Systems, 
 *                     Inc. All rights reserved. This program and the accompanying materials are made 
 *                     available under the terms of the Eclipse Public License v1.0 which accompanies 
 *                     this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *         ";
 *     }
 *
 *     list instructions-queue {
 *         key "instruction-queue-id"
 *         leaf instruction-queue-id {
 *             type string;
 *         }
 *         list instruction {
 *             key "id"
 *             leaf id {
 *                 type instruction-id;
 *             }
 *             leaf status {
 *                 type instruction-status;
 *             }
 *             leaf deadline {
 *                 type nanotime;
 *             }
 *         }
 *         uses instruction-queue;
 *     }
 *
 *     grouping submit-instruction-input {
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf deadline {
 *             type nanotime;
 *         }
 *         leaf-list preconditions {
 *             type instruction-id;
 *         }
 *     }
 *     grouping instruction-queue {
 *         leaf instruction-queue-id {
 *             type string;
 *         }
 *         list instruction {
 *             key "id"
 *             leaf id {
 *                 type instruction-id;
 *             }
 *             leaf status {
 *                 type instruction-status;
 *             }
 *             leaf deadline {
 *                 type nanotime;
 *             }
 *         }
 *     }
 *     grouping submit-instruction-output {
 *         choice result {
 *             case failure-case {
 *                 container failure {
 *                     leaf type {
 *                         type identityref;
 *                     }
 *                     leaf-list failed-preconditions {
 *                         type instruction-id;
 *                     }
 *                 }
 *             }
 *         }
 *     }
 *
 *     identity uncancellable-instruction {
 *         base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)cancel-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)cancel-failure]}}";
 *         description
 *             "The specified instruction is in process of being
 *                         executed and cannot be cancelled. Wait for the
 *                         execution process to complete.";
 *         status CURRENT;
 *     }
 *     identity unknown-instruction {
 *         base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)cancel-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)cancel-failure]}}";
 *         description
 *             "The specified instruction ID has not been found
 *                         in the queue.";
 *         status CURRENT;
 *     }
 *     identity dead-on-arrival {
 *         base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *         description
 *             "The instruction was submitted after its deadline has
 *                         passed, or one of its dependencies resolved as
 *                         non-sunccessful.";
 *         status CURRENT;
 *     }
 *     identity duplicate-instruction-id {
 *         base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *         description
 *             "Instruction ID clashes with an instruction with an
 *                         already-queued instruction. Assign a new identifier
 *                         or wait for the enqueued instruction to complete.";
 *         status CURRENT;
 *     }
 *     identity unknown-precondition-id {
 *         base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *         description
 *             "One of the instruction IDs specified in the
 *                         precondition list is unknown.";
 *         status CURRENT;
 *     }
 *     identity cancel-failure {
 *         description
 *             "The base identity of various reasons for an
 *                         instruction cancellation to fail.";
 *         status CURRENT;
 *     }
 *     identity too-many-instructions {
 *         base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *         description
 *             "Instruction queue size exceeded.";
 *         status CURRENT;
 *     }
 *     identity submit-failure {
 *         description
 *             "The base identity of various reasons for an
 *                         instruction submission to fail.";
 *         status CURRENT;
 *     }
 *
 *     notification instruction-status-changed {
 *         leaf id {
 *             type instruction-id;
 *         }
 *         leaf status {
 *             type instruction-status;
 *         }
 *         container details {
 *             leaf-list unmet-dependencies {
 *                 type instruction-id;
 *             }
 *         }
 *     }
 *
 *     rpc clean-instructions {
 *         "Attempt to clean out a certain set of instructions.
 *                     Instructions flushed this way need to be in a terminal
 *                     state, e.g. Successful, Failed or Cancelled. Instructions
 *                     which were not cleaned are reported in the output of
 *                     this RPC.";
 *         input {
 *             leaf-list id {
 *                 type instruction-id;
 *             }
 *         }
 *         
 *         output {
 *             leaf-list unflushed {
 *                 type instruction-id;
 *             }
 *         }
 *     }
 *     rpc cancel-instruction {
 *         input {
 *             leaf id {
 *                 type instruction-id;
 *             }
 *         }
 *         
 *         output {
 *             leaf failure {
 *                 type identityref;
 *             }
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface ProgrammingData
    extends
    DataRoot
{




    /**
     * @return <code>java.util.List</code> <code>instructionsQueue</code>, or <code>null</code> if not present
     */
    List<InstructionsQueue> getInstructionsQueue();

}

