package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

/**
 * Interface for receiving the following YANG notifications defined in module <b>programming</b>
 * <pre>
 * notification instruction-status-changed {
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf status {
 *         type instruction-status;
 *     }
 *     container details {
 *         leaf-list unmet-dependencies {
 *             type instruction-id;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface ProgrammingListener
    extends
    NotificationListener
{




    void onInstructionStatusChanged(InstructionStatusChanged notification);

}

