package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import java.util.concurrent.Future;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>programming</b>
 * <pre>
 * rpc clean-instructions {
 *     "Attempt to clean out a certain set of instructions.
 *                 Instructions flushed this way need to be in a terminal
 *                 state, e.g. Successful, Failed or Cancelled. Instructions
 *                 which were not cleaned are reported in the output of
 *                 this RPC.";
 *     input {
 *         leaf-list id {
 *             type instruction-id;
 *         }
 *     }
 *     
 *     output {
 *         leaf-list unflushed {
 *             type instruction-id;
 *         }
 *     }
 * }
 * rpc cancel-instruction {
 *     input {
 *         leaf id {
 *             type instruction-id;
 *         }
 *     }
 *     
 *     output {
 *         leaf failure {
 *             type identityref;
 *         }
 *     }
 * }
 * </pre>
 *
 */
public interface ProgrammingService
    extends
    RpcService
{




    /**
     * Attempt to clean out a certain set of instructions. Instructions flushed this 
     * way need to be in a terminal state, e.g. Successful, Failed or Cancelled. 
     * Instructions which were not cleaned are reported in the output of this RPC.
     *
     */
    Future<RpcResult<CleanInstructionsOutput>> cleanInstructions(CleanInstructionsInput input);
    
    Future<RpcResult<CancelInstructionOutput>> cancelInstruction(CancelInstructionInput input);

}

