package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import java.util.List;

/**
 * Minimum required arguments needed for submitting an instruction into the 
 * scheduler. This grouping needs to be used by concrete RPC definitions which are 
 * routed to the scheduler.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * grouping submit-instruction-input {
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/submit-instruction-input</i>
 *
 */
public interface SubmitInstructionInput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "submit-instruction-input").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId</code> <code>id</code>, or <code>null</code> if not present
     */
    InstructionId getId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime</code> <code>deadline</code>, or <code>null</code> if not present
     */
    Nanotime getDeadline();
    
    /**
     * @return <code>java.util.List</code> <code>preconditions</code>, or <code>null</code> if not present
     */
    List<InstructionId> getPreconditions();

}

