package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.submit.instruction.output.Result;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * grouping submit-instruction-output {
 *     choice result {
 *         case failure-case {
 *             container failure {
 *                 leaf type {
 *                     type identityref;
 *                 }
 *                 leaf-list failed-preconditions {
 *                     type instruction-id;
 *                 }
 *             }
 *         }
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/submit-instruction-output</i>
 *
 */
public interface SubmitInstructionOutput
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "submit-instruction-output").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.submit.instruction.output.Result</code> <code>result</code>, or <code>null</code> if not present
     */
    Result getResult();

}

