package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Instruction queue size exceeded.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * identity too-many-instructions {
 *     base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *     description
 *         "Instruction queue size exceeded.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/too-many-instructions</i>
 *
 */
public abstract class TooManyInstructions extends SubmitFailure
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "too-many-instructions").intern();


    public TooManyInstructions() {
    
    
    }
    






}

