package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * The specified instruction is in process of being executed and cannot be 
 * cancelled. Wait for the execution process to complete.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * identity uncancellable-instruction {
 *     base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)cancel-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)cancel-failure]}}";
 *     description
 *         "The specified instruction is in process of being
 *                     executed and cannot be cancelled. Wait for the
 *                     execution process to complete.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/uncancellable-instruction</i>
 *
 */
public abstract class UncancellableInstruction extends CancelFailure
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "uncancellable-instruction").intern();


    public UncancellableInstruction() {
    
    
    }
    






}

