package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * One of the instruction IDs specified in the precondition list is unknown.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * identity unknown-precondition-id {
 *     base "()IdentityEffectiveStatementImpl{qname=(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure, path=AbsoluteSchemaPath{path=[(urn:opendaylight:params:xml:ns:yang:programming?revision=2015-07-20)submit-failure]}}";
 *     description
 *         "One of the instruction IDs specified in the
 *                     precondition list is unknown.";
 *     status CURRENT;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/unknown-precondition-id</i>
 *
 */
public abstract class UnknownPreconditionId extends SubmitFailure
 {
    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "unknown-precondition-id").intern();


    public UnknownPreconditionId() {
    
    
    }
    






}

