package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionQueue;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yangtools.yang.binding.Identifiable;

/**
 * List of all instructions known to the scheduler.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * list instruction {
 *     key "id"
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf status {
 *         type instruction-status;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/instruction-queue/instruction</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionBuilder
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionKey
 *
 */
public interface Instruction
    extends
    ChildOf<InstructionQueue>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.Instruction>,
    Identifiable<InstructionKey>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "instruction").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId</code> <code>id</code>, or <code>null</code> if not present
     */
    InstructionId getId();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatus</code> <code>status</code>, or <code>null</code> if not present
     */
    InstructionStatus getStatus();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime</code> <code>deadline</code>, or <code>null</code> if not present
     */
    Nanotime getDeadline();
    
    /**
     * Returns Primary Key of Yang List Type
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.queue.InstructionKey</code> <code>key</code>, or <code>null</code> if not present
     */
    InstructionKey getKey();

}

