package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.status.changed;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionStatusChanged;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * More details about the instruction state.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>programming</b>
 * <pre>
 * container details {
 *     leaf-list unmet-dependencies {
 *         type instruction-id;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>programming/instruction-status-changed/details</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.status.changed.DetailsBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.status.changed.DetailsBuilder
 *
 */
public interface Details
    extends
    ChildOf<InstructionStatusChanged>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.instruction.status.changed.Details>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:programming",
        "2015-07-20", "details").intern();

    /**
     * @return <code>java.util.List</code> <code>unmetDependencies</code>, or <code>null</code> if not present
     */
    List<InstructionId> getUnmetDependencies();

}

