package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.programming.rev131102;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>network-topology-programming</b>
 * <pre>
 * grouping topology-instruction-input {
 *     leaf id {
 *         type instruction-id;
 *     }
 *     leaf deadline {
 *         type nanotime;
 *     }
 *     leaf-list preconditions {
 *         type instruction-id;
 *     }
 *     leaf network-topology-ref {
 *         type network-topology-ref;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>network-topology-programming/topology-instruction-input</i>
 *
 */
public interface TopologyInstructionInput
    extends
    DataObject,
    NetworkTopologyReference,
    SubmitInstructionInput
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:topology:programming",
        "2013-11-02", "topology-instruction-input").intern();


}

