/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DestinationBuilder
implements Builder<Destination> {
    private NodeId _node;
    private TpId _tp;
    Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();

    public DestinationBuilder() {
    }

    public DestinationBuilder(TpReference arg) {
        this._node = arg.getNode();
        this._tp = arg.getTp();
    }

    public DestinationBuilder(Destination base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>(aug);
        }
        this._node = base.getNode();
        this._tp = base.getTp();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpReference) {
            this._node = ((TpReference)arg).getNode();
            this._tp = ((TpReference)arg).getTp();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[TpReference]");
    }

    public NodeId getNode() {
        return this._node;
    }

    public TpId getTp() {
        return this._tp;
    }

    public <E$$ extends Augmentation<Destination>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public DestinationBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public DestinationBuilder setTp(TpId value) {
        this._tp = value;
        return this;
    }

    public DestinationBuilder addAugmentation(Augmentation<Destination> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public DestinationBuilder removeAugmentation(Class<? extends Augmentation<Destination>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Destination build() {
        return new DestinationImpl(this);
    }

    private static final class DestinationImpl
    extends AbstractAugmentable<Destination>
    implements Destination {
        private final NodeId _node;
        private final TpId _tp;
        private int hash = 0;
        private volatile boolean hashValid = false;

        DestinationImpl(DestinationBuilder base) {
            super(base.augmentation);
            this._node = base.getNode();
            this._tp = base.getTp();
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TpId getTp() {
            return this._tp;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Destination.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Destination.bindingEquals(this, obj);
        }

        public String toString() {
            return Destination.bindingToString(this);
        }
    }
}

