/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.protocols;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FluentFuture;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.bgpcep.config.loader.spi.AbstractConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.NetworkInstances;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.NetworkInstance;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.network.instance.Protocols;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.network.instance.rev151018.network.instance.top.network.instances.network.instance.protocols.Protocol;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Singleton
public final class ProtocolsConfigFileProcessor
extends AbstractConfigFileProcessor {
    private static final QName NAME = QName.create((QName)NetworkInstance.QNAME, (String)"name").intern();
    @VisibleForTesting
    static final String GLOBAL_BGP_NAME = "global-bgp";
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates GLOBAL_BGP = YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)NetworkInstance.QNAME, (QName)NAME, (Object)"global-bgp");
    private static final @NonNull YangInstanceIdentifier GLOBAL_BGP_PATH = YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{YangInstanceIdentifier.NodeIdentifier.create((QName)NetworkInstances.QNAME), YangInstanceIdentifier.NodeIdentifier.create((QName)NetworkInstance.QNAME), GLOBAL_BGP});

    @Inject
    public ProtocolsConfigFileProcessor(ConfigLoader configLoader, DOMDataBroker dataBroker) {
        super("Protocols", configLoader, dataBroker);
    }

    @PostConstruct
    public void init() {
        this.start();
    }

    @PreDestroy
    public void close() {
        this.stop();
    }

    public SchemaNodeIdentifier.Absolute fileRootSchema() {
        return SchemaNodeIdentifier.Absolute.of((QName[])new QName[]{NetworkInstances.QNAME, NetworkInstance.QNAME, Protocols.QNAME});
    }

    protected FluentFuture<? extends CommitInfo> loadConfiguration(DOMDataBroker dataBroker, NormalizedNode dto) {
        ContainerNode protocolsContainer = (ContainerNode)dto;
        MapNode protocols = (MapNode)protocolsContainer.childByArg((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Protocol.QNAME));
        if (protocols == null) {
            return CommitInfo.emptyFluentFuture();
        }
        DOMDataTreeWriteTransaction wtx = dataBroker.newWriteOnlyTransaction();
        wtx.merge(LogicalDatastoreType.CONFIGURATION, GLOBAL_BGP_PATH, ImmutableNodes.newMapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)GLOBAL_BGP).withChild((DataContainerChild)ImmutableNodes.leafNode((QName)NAME, (Object)GLOBAL_BGP_NAME)).build());
        wtx.merge(LogicalDatastoreType.CONFIGURATION, GLOBAL_BGP_PATH.node(Protocols.QNAME).node((YangInstanceIdentifier.PathArgument)protocols.name()), (NormalizedNode)protocols);
        return wtx.commit();
    }
}

