/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.routing.policy;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.bgpcep.config.loader.spi.ConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenconfigRoutingPolicyLoader
implements ConfigFileProcessor,
AutoCloseable {
    public static final InstanceIdentifier<RoutingPolicy> ROUTING_POLICY_IID = InstanceIdentifier.create(RoutingPolicy.class);
    private static final Logger LOG = LoggerFactory.getLogger(OpenconfigRoutingPolicyLoader.class);
    private static final SchemaPath POLICY_SCHEMA_PATH = SchemaPath.create((boolean)true, (QName)RoutingPolicy.QNAME);
    private final BindingNormalizedNodeSerializer bindingSerializer;
    private final ConfigLoader configLoader;
    private final DataBroker dataBroker;
    private final YangInstanceIdentifier routingPolicyYiid;
    private @GuardedBy(value={"this"}) AbstractRegistration registration;

    public OpenconfigRoutingPolicyLoader(ConfigLoader configLoader, DataBroker dataBroker) {
        Objects.requireNonNull(configLoader);
        this.configLoader = Objects.requireNonNull(configLoader);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.bindingSerializer = configLoader.getBindingNormalizedNodeSerializer();
        this.routingPolicyYiid = this.bindingSerializer.toYangInstanceIdentifier(ROUTING_POLICY_IID);
    }

    public synchronized void init() {
        this.registration = this.configLoader.registerConfigFile((ConfigFileProcessor)this);
        LOG.info("Routing Policy Config Loader service initiated");
    }

    @Override
    public synchronized void close() {
        if (this.registration != null) {
            this.registration.close();
            this.registration = null;
        }
    }

    public SchemaPath getSchemaPath() {
        return POLICY_SCHEMA_PATH;
    }

    public void loadConfiguration(NormalizedNode<?, ?> dto) {
        RoutingPolicy routingPolicy = (RoutingPolicy)this.bindingSerializer.fromNormalizedNode(this.routingPolicyYiid, dto).getValue();
        WriteTransaction wtx = this.dataBroker.newWriteOnlyTransaction();
        wtx.merge(LogicalDatastoreType.CONFIGURATION, ROUTING_POLICY_IID, (DataObject)routingPolicy);
        try {
            wtx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to create Routing Policy config", (Throwable)e);
        }
    }
}

