/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.bgpcep.config.loader.routing.policy;

import com.google.common.util.concurrent.FluentFuture;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.bgpcep.config.loader.spi.AbstractConfigFileProcessor;
import org.opendaylight.bgpcep.config.loader.spi.ConfigLoader;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.routing.policy.rev151009.routing.policy.top.RoutingPolicy;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Singleton
public final class OpenconfigRoutingConfigFileProcessor
extends AbstractConfigFileProcessor {
    @Inject
    public OpenconfigRoutingConfigFileProcessor(ConfigLoader configLoader, DOMDataBroker dataBroker) {
        super("Routing Policy", configLoader, dataBroker);
    }

    @PostConstruct
    public void init() {
        this.start();
    }

    @PreDestroy
    public void close() {
        this.stop();
    }

    public SchemaNodeIdentifier.Absolute fileRootSchema() {
        return SchemaNodeIdentifier.Absolute.of((QName)RoutingPolicy.QNAME);
    }

    protected FluentFuture<? extends CommitInfo> loadConfiguration(DOMDataBroker dataBroker, NormalizedNode dto) {
        DOMDataTreeWriteTransaction wtx = dataBroker.newWriteOnlyTransaction();
        wtx.put(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(RoutingPolicy.QNAME)), dto);
        return wtx.commit();
    }
}

