/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum LspFlag implements Enumeration
{
    Unprotected(0, "unprotected"),
    FullRerouting(1, "full-rerouting"),
    ReroutingWithoutExtraTraffic(2, "rerouting-without-extra-traffic"),
    ProtectionWithExtraTraffic(4, "protection-with-extra-traffic"),
    UnidirectionalProtection(8, "unidirectional-protection"),
    BidirectionalProtection(10, "bidirectional-protection");

    private static final Map<String, LspFlag> NAME_MAP;
    private static final Map<Integer, LspFlag> VALUE_MAP;
    private final String name;
    private final int value;

    private LspFlag(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<LspFlag> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static LspFlag forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (LspFlag enumItem : LspFlag.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

