/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.attribute.flags.FlagContainer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlagContainerBuilder
implements Builder<FlagContainer> {
    private byte[] _flags;
    Map<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>> augmentation = Collections.emptyMap();

    public FlagContainerBuilder() {
    }

    public FlagContainerBuilder(FlagContainer base) {
        AugmentationHolder casted;
        this._flags = base.getFlags();
        if (base instanceof FlagContainerImpl) {
            FlagContainerImpl impl = (FlagContainerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>>(casted.augmentations());
        }
    }

    public byte[] getFlags() {
        return this._flags == null ? null : (byte[])this._flags.clone();
    }

    public <E extends Augmentation<FlagContainer>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void check_flagsLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[4..4]]", (byte[])value);
    }

    public FlagContainerBuilder setFlags(byte[] value) {
        if (value != null) {
            FlagContainerBuilder.check_flagsLength(value);
        }
        this._flags = value;
        return this;
    }

    public FlagContainerBuilder addAugmentation(Class<? extends Augmentation<FlagContainer>> augmentationType, Augmentation<FlagContainer> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FlagContainerBuilder removeAugmentation(Class<? extends Augmentation<FlagContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlagContainer build() {
        return new FlagContainerImpl(this);
    }

    private static final class FlagContainerImpl
    implements FlagContainer {
        private final byte[] _flags;
        private Map<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private FlagContainerImpl(FlagContainerBuilder base) {
            this._flags = base.getFlags();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<FlagContainer> getImplementedInterface() {
            return FlagContainer.class;
        }

        @Override
        public byte[] getFlags() {
            return this._flags == null ? null : (byte[])this._flags.clone();
        }

        public <E extends Augmentation<FlagContainer>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this._flags);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlagContainer.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlagContainer other = (FlagContainer)obj;
            if (!Arrays.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlagContainerImpl otherImpl = (FlagContainerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlagContainer>>, Augmentation<FlagContainer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"FlagContainer");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_flags", (byte[])this._flags);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

