/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.metric.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.metric.object.MetricObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetricObjectBuilder
implements Builder<MetricObject> {
    private Short _metricType;
    private Float32 _value;
    private Boolean _bound;
    private Boolean _computed;
    Map<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>> augmentation = Collections.emptyMap();

    public MetricObjectBuilder() {
    }

    public MetricObjectBuilder(MetricObject base) {
        AugmentationHolder casted;
        this._metricType = base.getMetricType();
        this._value = base.getValue();
        this._bound = base.isBound();
        this._computed = base.isComputed();
        if (base instanceof MetricObjectImpl) {
            MetricObjectImpl impl = (MetricObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>>(casted.augmentations());
        }
    }

    public Short getMetricType() {
        return this._metricType;
    }

    public Float32 getValue() {
        return this._value;
    }

    public Boolean isBound() {
        return this._bound;
    }

    public Boolean isComputed() {
        return this._computed;
    }

    public <E extends Augmentation<MetricObject>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMetricTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (Object)value);
    }

    public MetricObjectBuilder setMetricType(Short value) {
        if (value != null) {
            MetricObjectBuilder.checkMetricTypeRange(value);
        }
        this._metricType = value;
        return this;
    }

    public MetricObjectBuilder setValue(Float32 value) {
        this._value = value;
        return this;
    }

    public MetricObjectBuilder setBound(Boolean value) {
        this._bound = value;
        return this;
    }

    public MetricObjectBuilder setComputed(Boolean value) {
        this._computed = value;
        return this;
    }

    public MetricObjectBuilder addAugmentation(Class<? extends Augmentation<MetricObject>> augmentationType, Augmentation<MetricObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MetricObjectBuilder removeAugmentation(Class<? extends Augmentation<MetricObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public MetricObject build() {
        return new MetricObjectImpl(this);
    }

    private static final class MetricObjectImpl
    implements MetricObject {
        private final Short _metricType;
        private final Float32 _value;
        private final Boolean _bound;
        private final Boolean _computed;
        private Map<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private MetricObjectImpl(MetricObjectBuilder base) {
            this._metricType = base.getMetricType();
            this._value = base.getValue();
            this._bound = base.isBound();
            this._computed = base.isComputed();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<MetricObject> getImplementedInterface() {
            return MetricObject.class;
        }

        @Override
        public Short getMetricType() {
            return this._metricType;
        }

        @Override
        public Float32 getValue() {
            return this._value;
        }

        @Override
        public Boolean isBound() {
            return this._bound;
        }

        @Override
        public Boolean isComputed() {
            return this._computed;
        }

        public <E extends Augmentation<MetricObject>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._metricType);
            result = 31 * result + Objects.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._bound);
            result = 31 * result + Objects.hashCode(this._computed);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MetricObject.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MetricObject other = (MetricObject)obj;
            if (!Objects.equals(this._metricType, other.getMetricType())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._bound, other.isBound())) {
                return false;
            }
            if (!Objects.equals(this._computed, other.isComputed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MetricObjectImpl otherImpl = (MetricObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MetricObject>>, Augmentation<MetricObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"MetricObject");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_metricType", (Object)this._metricType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bound", (Object)this._bound);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_computed", (Object)this._computed);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

